/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.item;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.azure.azurelib.common.animation.AzAnimator;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.item.AzItemModelRenderer;
import mod.azure.azurelib.common.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.common.render.item.AzItemRendererPipelineContext;
import mod.azure.azurelib.common.render.layer.AzRenderLayer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class AzItemRendererConfig
extends AzRendererConfig<UUID, class_1799> {
    private final boolean useEntityGuiLighting;
    private final boolean useNewOffset;
    private final Predicate<class_811> shouldAnimateInContext;

    private AzItemRendererConfig(Supplier<AzAnimator<UUID, class_1799>> animatorProvider, Function<class_1799, class_2960> modelLocationProvider, Function<class_1799, class_1921> renderTypeProvider, List<AzRenderLayer<UUID, class_1799>> renderLayers, Function<AzRendererPipelineContext<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> preRenderEntry, Function<AzRendererPipelineContext<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> renderEntry, Function<AzRendererPipelineContext<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> postRenderEntry, Function<class_1799, class_2960> textureLocationProvider, Function<class_1799, Float> alphaFunction, Function<class_1799, Float> scaleHeight, Function<class_1799, Float> scaleWidth, boolean useEntityGuiLighting, boolean useNewOffset, Predicate<class_811> shouldAnimateInContext, BiFunction<AzRendererPipeline<UUID, class_1799>, AzLayerRenderer<UUID, class_1799>, AzModelRenderer<UUID, class_1799>> modelRendererProvider, Function<AzRendererPipeline<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> pipelineContextFunction, Function<AzBone, class_2960> boneTextureOverrideProvider, Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
        super(animatorProvider, (a, b) -> (class_2960)modelLocationProvider.apply((class_1799)b), modelRendererProvider, pipelineContextFunction, (a, b) -> (class_1921)renderTypeProvider.apply((class_1799)b), renderLayers, preRenderEntry, renderEntry, postRenderEntry, (a, b) -> (class_2960)textureLocationProvider.apply((class_1799)b), alphaFunction, scaleHeight, scaleWidth, boneTextureOverrideProvider, boneRenderTypeOverrideProvider);
        this.useEntityGuiLighting = useEntityGuiLighting;
        this.useNewOffset = useNewOffset;
        this.shouldAnimateInContext = shouldAnimateInContext;
    }

    public boolean useEntityGuiLighting() {
        return this.useEntityGuiLighting;
    }

    public boolean useNewOffset() {
        return this.useNewOffset;
    }

    public boolean shouldAnimateInContext(class_811 context) {
        return this.shouldAnimateInContext.test(context);
    }

    public static Builder builder(class_2960 modelLocation, class_2960 textureLocation) {
        return new Builder($ -> modelLocation, $ -> textureLocation);
    }

    public static Builder builder(Function<class_1799, class_2960> modelLocationProvider, Function<class_1799, class_2960> textureLocationProvider) {
        return new Builder(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder
    extends AzRendererConfig.Builder<UUID, class_1799> {
        private boolean useEntityGuiLighting;
        private boolean useNewOffset;
        private Predicate<class_811> shouldAnimateInContext;

        protected Builder(Function<class_1799, class_2960> modelLocationProvider, Function<class_1799, class_2960> textureLocationProvider) {
            super((class_1297 a, T b) -> (class_2960)modelLocationProvider.apply((class_1799)b), (class_1297 a, T b) -> (class_2960)textureLocationProvider.apply((class_1799)b));
            this.renderTypeProvider = (a, b) -> class_1921.method_23578((class_2960)((class_2960)textureLocationProvider.apply((class_1799)b)));
            this.useEntityGuiLighting = false;
            this.useNewOffset = false;
            this.shouldAnimateInContext = $ -> true;
            this.modelRendererProvider = (entityRendererPipeline, layer) -> new AzItemModelRenderer((AzItemRendererPipeline)entityRendererPipeline, (AzLayerRenderer<UUID, class_1799>)layer);
            this.pipelineContextFunction = AzItemRendererPipelineContext::new;
        }

        public Builder setBoneRenderTypeOverrideProvider(Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
            return (Builder)super.setBoneRenderTypeOverrideProvider(boneRenderTypeOverrideProvider);
        }

        public Builder setBoneTextureOverrideProvider(Function<AzBone, class_2960> boneTextureOverrideProvider) {
            return (Builder)super.setBoneTextureOverrideProvider(boneTextureOverrideProvider);
        }

        public Builder setModelRenderer(BiFunction<AzRendererPipeline<UUID, class_1799>, AzLayerRenderer<UUID, class_1799>, AzModelRenderer<UUID, class_1799>> modelRendererProvider) {
            return (Builder)super.setModelRenderer(modelRendererProvider);
        }

        public Builder setPipelineContext(Function<AzRendererPipeline<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> azRendererPipelineAzRendererPipelineContextFunction) {
            return (Builder)super.setPipelineContext(azRendererPipelineAzRendererPipelineContextFunction);
        }

        public Builder addRenderLayer(AzRenderLayer<UUID, class_1799> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder setRenderType(class_1921 renderType) {
            this.renderTypeProvider = (a, b) -> renderType;
            return this;
        }

        public Builder setRenderType(Function<class_1799, class_1921> renderTypeProvider) {
            this.renderTypeProvider = (a, b) -> (class_1921)renderTypeProvider.apply((class_1799)b);
            return this;
        }

        public Builder setRenderType(BiFunction<class_1297, class_1799, class_1921> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        public Builder setPrerenderEntry(Function<AzRendererPipelineContext<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        public Builder setRenderEntry(Function<AzRendererPipelineContext<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> renderEntry) {
            return (Builder)super.setRenderEntry(renderEntry);
        }

        public Builder setPostRenderEntry(Function<AzRendererPipelineContext<UUID, class_1799>, AzRendererPipelineContext<UUID, class_1799>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        public Builder setAnimatorProvider(Supplier<@Nullable AzAnimator<UUID, class_1799>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder setAlpha(Function<class_1799, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        public Builder setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        public Builder setScale(Function<class_1799, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        public Builder setScale(Function<class_1799, Float> scaleHeightFunction, Function<class_1799, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        public Builder setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        public Builder setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public Builder useEntityGuiLighting() {
            this.useEntityGuiLighting = true;
            return this;
        }

        public Builder useNewOffset(boolean useNewOffset) {
            this.useNewOffset = useNewOffset;
            return this;
        }

        public Builder setShouldAnimateInContext(Predicate<class_811> shouldAnimateInContext) {
            this.shouldAnimateInContext = shouldAnimateInContext;
            return this;
        }

        public Builder disableAnimationInContexts(class_811 contextToDisable, class_811 ... contextsToDisable) {
            HashSet<class_811> disabledContexts = new HashSet<class_811>();
            disabledContexts.add(contextToDisable);
            if (contextsToDisable.length > 0) {
                disabledContexts.addAll(Arrays.asList(contextsToDisable));
            }
            Set finalDisabledContexts = Set.copyOf(disabledContexts);
            this.shouldAnimateInContext = context -> !finalDisabledContexts.contains(context);
            return this;
        }

        public Builder enableAnimationOnlyInContexts(class_811 contextToEnable, class_811 ... contextsToEnable) {
            HashSet<class_811> enabledContexts = new HashSet<class_811>();
            enabledContexts.add(contextToEnable);
            if (contextsToEnable.length > 0) {
                enabledContexts.addAll(Arrays.asList(contextsToEnable));
            }
            Set finalEnabledContexts = Set.copyOf(enabledContexts);
            this.shouldAnimateInContext = finalEnabledContexts::contains;
            return this;
        }

        public Builder disableAnimationInAllContexts() {
            this.shouldAnimateInContext = context -> false;
            return this;
        }

        public AzItemRendererConfig build() {
            AzRendererConfig baseConfig = super.build();
            return new AzItemRendererConfig(baseConfig::createAnimator, baseConfig::modelLocation, baseConfig::getRenderType, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::renderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, this.useEntityGuiLighting, this.useNewOffset, this.shouldAnimateInContext, baseConfig::modelRendererProvider, baseConfig::pipelineContext, baseConfig::boneTextureOverrideProvider, baseConfig::boneRenderTypeOverrideProvider);
        }
    }
}

