/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import travelers.client.TravelersClient;
import travelers.client.misc.CameraShakeHandler;
import travelers.client.misc.FogHandler;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.entity.SmartAnimalBase;

@Mod.EventBusSubscriber(modid="travelerslib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientGameEvents {
    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Iterator<CameraShakeHandler.ShakeInstance> it = CameraShakeHandler.shakes.iterator();
        while (it.hasNext()) {
            CameraShakeHandler.ShakeInstance s = it.next();
            --s.ticks;
            if (s.ticks > 0) continue;
            it.remove();
        }
        ++TravelersClient.clientTicks;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            TravelersClient.getUuidEntityMap().clear();
            return;
        }
        HashSet<Entity> loadedThisTick = new HashSet<Entity>();
        for (Entity e : mc.f_91073_.m_104735_()) {
            loadedThisTick.add(e);
        }
        for (Entity entity : loadedThisTick) {
            if (TravelersClient.getUuidEntityMap().containsKey(entity.m_20148_())) continue;
            TravelersClient.getUuidEntityMap().put(entity.m_20148_(), entity);
        }
        FogHandler.lerpFog();
        TravelersClient.getUuidEntityMap().entrySet().removeIf(uuidEntityEntry -> !loadedThisTick.contains(uuidEntityEntry.getValue()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void entityLeaveEvent(EntityLeaveLevelEvent event) {
        SmartAnimalBase a;
        TravelersClientAnimator animator;
        if (!event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof SmartAnimalBase && (animator = TravelersAnimationMap.get(a = (SmartAnimalBase)entity)) != null) {
            animator.remove(a);
        }
    }

    @SubscribeEvent
    public static void onCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        if (!CameraShakeHandler.shakes.isEmpty()) {
            float maxStrength = 0.0f;
            for (CameraShakeHandler.ShakeInstance s : CameraShakeHandler.shakes) {
                if (s.checkForGround && !event.getCamera().m_90592_().m_20096_() || !(s.strength > maxStrength)) continue;
                maxStrength = s.strength;
            }
            float totalYaw = (float)((Math.random() - 0.5) * (double)maxStrength);
            float totalPitch = (float)((Math.random() - 0.5) * (double)maxStrength);
            event.setYaw(event.getYaw() + totalYaw);
            event.setPitch(event.getPitch() + totalPitch);
        }
    }

    @SubscribeEvent
    public static void fogDistance(ViewportEvent.RenderFog event) {
        float fog = FogHandler.getFogFactor();
        if (fog > 1.0f) {
            event.setCanceled(false);
            return;
        }
        float near = Math.max(0.1f, fog * fog * event.getNearPlaneDistance());
        float far = Math.max(4.0f, fog * event.getFarPlaneDistance());
        event.setNearPlaneDistance(near);
        event.setFarPlaneDistance(far);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void fogColor(ViewportEvent.ComputeFogColor event) {
        float fog = FogHandler.getFogFactor();
        FogHandler.setDB(event.getBlue());
        FogHandler.setDG(event.getGreen());
        FogHandler.setDR(event.getRed());
        if (fog >= 1.0f) {
            return;
        }
        event.setRed(FogHandler.getR());
        event.setGreen(FogHandler.getG());
        event.setBlue(FogHandler.getB());
    }

    @SubscribeEvent
    public static void onCameraFov(ViewportEvent.ComputeFov event) {
        if (!CameraShakeHandler.shakes.isEmpty()) {
            float maxStrength = 0.0f;
            for (CameraShakeHandler.ShakeInstance s : CameraShakeHandler.shakes) {
                if (s.checkForGround && !event.getCamera().m_90592_().m_20096_() || !(s.strength > maxStrength)) continue;
                maxStrength = s.strength;
            }
            float totalFov = (float)((Math.random() - 0.5) * (double)(maxStrength + maxStrength));
            event.setFOV(event.getFOV() + (double)totalFov);
        }
    }
}

