/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import com.google.common.base.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import travelers.GeckoLibDisabler;
import travelers.NeoPackets;
import travelers.TravelersConstants;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.packet.obj.TravelersBasePacket;
import travelers.server.world.TravelersBiomeModificator;
import travelers.util.helper.obj.IGenericProperties;
import travelers.world.NeoTravelersBiomeModificator;

public class NeoGenericProperties
implements IGenericProperties {
    private static final NeoTravelersBiomeModificator biomeModificator = new NeoTravelersBiomeModificator();

    @Override
    public String getPlatformName() {
        return "neoforge";
    }

    @Override
    public MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToPlayersTrackingEntity(Entity mob, T payload) {
        if (mob.m_9236_() instanceof ServerLevel) {
            NeoPackets.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> mob), payload);
        }
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToPlayersTrackingBlockEntity(BlockEntity mob, T payload) {
        if (mob.m_58904_() instanceof ServerLevel) {
            NeoPackets.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> mob.m_58904_().m_46745_(mob.m_58899_())), payload);
        }
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToServer(T payload) {
        NeoPackets.CHANNEL.sendToServer(payload);
    }

    @Override
    public <T extends TravelersBasePacket<T>> void sendToPlayer(ServerPlayer player, T payload) {
        if (player.m_9236_() instanceof ServerLevel) {
            NeoPackets.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), payload);
        }
    }

    @Override
    public <T> T register(Registry<T> registry, ResourceLocation id, Supplier<T> supplier) {
        TravelersConstants.LOGGER.error("Don't use the register method for NeoForge");
        return null;
    }

    @Override
    public <T extends SmartAnimalBase> void registerAnimal(TravelersAnimal<T> animal) {
        TravelersConstants.LOGGER.error("Don't use the register method for NeoForge");
    }

    @Override
    public boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getMods().stream().anyMatch(modInfo -> modInfo.getModId().equalsIgnoreCase(modId));
        }
        return ModList.get().isLoaded(modId);
    }

    @Override
    public TravelersBiomeModificator getBiomeModificator() {
        return biomeModificator;
    }

    @Override
    public void disableGecko(String modId) {
        GeckoLibDisabler.disableGecko(modId);
    }

    @Override
    public boolean isClient() {
        return false;
    }
}

