/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.RegisterEvent;
import travelers.NeoPackets;
import travelers.TravelersConstants;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;
import travelers.util.helper.PlatformHelper;
import travelers.util.helper.obj.TravelerRegistryObject;

@Mod.EventBusSubscriber(modid="travelerslib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NeoTravelersEvents {
    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void registerAttributes(EntityAttributeCreationEvent e) {
        for (Set<TravelersAnimal<?>> value : TravelersAnimalRegistry.getANIMALS().values()) {
            for (TravelersAnimal<?> animal : value) {
                e.put((EntityType)animal.getEntityType().get(), animal.createAnimalAttributes().m_22265_());
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(PlatformHelper.registryMap::clear);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(NeoPackets::registerPackets);
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        ArrayList snapshot = new ArrayList(PlatformHelper.registryMap);
        for (TravelerRegistryObject<?> obj : snapshot) {
            ResourceKey objKey = obj.registry().m_123023_();
            if (!objKey.equals((Object)key)) continue;
            try {
                if (key.equals((Object)Registries.f_256913_)) {
                    PlatformHelper.registryMap.stream().filter(o -> o.registry().m_123023_().equals((Object)Registries.f_256747_)).forEach(o -> o.supplier().get());
                }
                event.register(objKey, obj.location(), obj.supplier());
            }
            catch (Throwable t) {
                TravelersConstants.LOGGER.error("Error registering {}", (Object)obj.location(), (Object)t);
            }
        }
    }
}

