/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import travelers.TravelersDebug;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;

public class TravelersPathfindingRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Map<Integer, PathData> paths = new ConcurrentHashMap<Integer, PathData>();
    private static final long LIFETIME = 5000L;

    private static void renderPath(PoseStack pose, MultiBufferSource buf, PathData pathData, boolean showDebug, boolean showLabels, double camX, double camY, double camZ) {
        if (!TravelersDebug.debugPath) {
            return;
        }
        TravelersPath path = pathData.path;
        TravelersPathfindingRenderer.renderPathLine(pose, buf.m_6299_(RenderType.m_269399_((double)6.0)), path, camX, camY, camZ);
        BlockPos target = path.getTarget();
        if (TravelersPathfindingRenderer.distanceToCamera(target, camX, camY, camZ) <= 80.0f) {
            TravelersPathfindingRenderer.renderPillar(pose, buf, target, camX, camY, camZ, 0.0f, 1.0f, 0.0f, 0.6f);
        }
        for (int i = 0; i < path.getNodeCount(); ++i) {
            boolean typeChange;
            TravelersNode node = path.getNode(i);
            if (TravelersPathfindingRenderer.distanceToCamera(node.asBlockPos(), camX, camY, camZ) > 80.0f) continue;
            double nx = (double)node.x + 0.5 - camX;
            double ny = (double)node.y + 0.1 - camY;
            double nz = (double)node.z + 0.5 - camZ;
            if (i == 0) {
                TravelersPathfindingRenderer.renderSphere(pose, buf, nx, ny, nz, 0.3f, 0.0f, 1.0f, 0.0f, 0.8f);
            } else if (i == path.getNextNodeIndex()) {
                TravelersPathfindingRenderer.renderDiamond(pose, buf, nx, ny, nz, 0.35f, 1.0f, 0.85f, 0.0f, 0.9f);
            } else {
                TravelersPathfindingRenderer.renderDisc(pose, buf, nx, ny, nz, 0.25f, 0.2f, 0.6f, 1.0f, 0.7f);
            }
            if (!showLabels) continue;
            boolean first = i == 0;
            boolean last = i == path.getNodeCount() - 1;
            boolean bl = typeChange = !first && !path.getNode((int)(i - 1)).type.equals((Object)node.type);
            if (!first && !last && !typeChange) continue;
            DebugRenderer.m_269439_((PoseStack)pose, (MultiBufferSource)buf, (String)(String.valueOf((Object)node.type) + " | " + String.format(Locale.ROOT, "%.2f", Float.valueOf(node.costMalus))), (double)((double)node.x + 0.5), (double)((double)node.y + 0.9), (double)((double)node.z + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
        }
        if (showDebug && path.debugData() != null) {
            for (TravelersNode n : path.debugData().closedSet()) {
                TravelersPathfindingRenderer.renderSphere(pose, buf, (double)n.x + 0.5 - camX, (double)n.y + 0.1 - camY, (double)n.z + 0.5 - camZ, 0.15f, 1.0f, 0.3f, 0.3f, 0.5f);
            }
            for (TravelersNode n : path.debugData().openSet()) {
                TravelersPathfindingRenderer.renderSphere(pose, buf, (double)n.x + 0.5 - camX, (double)n.y + 0.1 - camY, (double)n.z + 0.5 - camZ, 0.15f, 0.3f, 1.0f, 1.0f, 0.5f);
            }
        }
    }

    private static void renderPathLine(PoseStack pose, VertexConsumer consumer, TravelersPath path, double camX, double camY, double camZ) {
        for (int i = 0; i < path.getNodeCount(); ++i) {
            TravelersNode node = path.getNode(i);
            if (TravelersPathfindingRenderer.distanceToCamera(node.asBlockPos(), camX, camY, camZ) > 80.0f) continue;
            float hue = (float)i / (float)path.getNodeCount();
            int rgb = Mth.m_14169_((float)hue, (float)1.0f, (float)1.0f);
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            consumer.m_252986_(pose.m_85850_().m_252922_(), (float)((double)node.x - camX + 0.5), (float)((double)node.y - camY + 0.5), (float)((double)node.z - camZ + 0.5)).m_6122_(r, g, b, 255);
        }
    }

    private static float distanceToCamera(BlockPos pos, double x, double y, double z) {
        double dx = (double)pos.m_123341_() + 0.5 - x;
        double dy = (double)pos.m_123342_() + 0.5 - y;
        double dz = (double)pos.m_123343_() + 0.5 - z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static void renderDisc(PoseStack stack, MultiBufferSource buf, double x, double y, double z, float radius, float r, float g, float b, float a) {
        DebugRenderer.m_269311_((PoseStack)stack, (MultiBufferSource)buf, (AABB)new AABB(x - (double)radius, y, z - (double)radius, x + (double)radius, y + 0.02, z + (double)radius), (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderSphere(PoseStack stack, MultiBufferSource buf, double x, double y, double z, float radius, float r, float g, float b, float a) {
        DebugRenderer.m_269311_((PoseStack)stack, (MultiBufferSource)buf, (AABB)new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius), (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderDiamond(PoseStack stack, MultiBufferSource buf, double x, double y, double z, float size, float r, float g, float b, float a) {
        DebugRenderer.m_269311_((PoseStack)stack, (MultiBufferSource)buf, (AABB)new AABB(x - (double)size, y - 0.1, z - (double)size, x + (double)size, y + (double)size * 1.5, z + (double)size), (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderPillar(PoseStack stack, MultiBufferSource buf, BlockPos pos, double camX, double camY, double camZ, float r, float g, float b, float a) {
        DebugRenderer.m_269311_((PoseStack)stack, (MultiBufferSource)buf, (AABB)new AABB((double)pos.m_123341_() + 0.25 - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() + 0.25 - camZ, (double)pos.m_123341_() + 0.75 - camX, (double)pos.m_123342_() + 2.0 - camY, (double)pos.m_123343_() + 0.75 - camZ), (float)r, (float)g, (float)b, (float)a);
    }

    public void addPath(int entityId, TravelersPath path, float maxDist) {
        this.paths.put(entityId, new PathData(path, maxDist, Util.m_137550_()));
    }

    public void m_7790_(PoseStack pose, MultiBufferSource buf, double camX, double camY, double camZ) {
        if (this.paths.isEmpty()) {
            return;
        }
        long now = Util.m_137550_();
        for (PathData data : this.paths.values()) {
            TravelersPathfindingRenderer.renderPath(pose, buf, data, true, true, camX, camY, camZ);
        }
        this.paths.entrySet().removeIf(e -> ((PathData)e.getValue()).path.isDone() || now - ((PathData)e.getValue()).created > 5000L);
    }

    private record PathData(TravelersPath path, float maxDist, long created) {
    }
}

