/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import travelers.util.TravelersAzure;
import travelers.util.helper.PlatformHelper;

public class CameraShakeHandler {
    public static final List<ShakeInstance> shakes = new ArrayList<ShakeInstance>();

    public static void startShake(boolean groundCheck, float strength, float maxDistance, int ticks, Vector3f vec3) {
        if (PlatformHelper.properties.isModLoaded("azurelib")) {
            if (!TravelersAzure.config.screenShake) {
                shakes.clear();
                return;
            }
            strength *= (float)TravelersAzure.config.screenShakeIntensity;
            double distance = 0.0;
            if (Minecraft.m_91087_().f_91074_ != null) {
                distance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(new Vec3((double)vec3.x, (double)vec3.y, (double)vec3.z));
            }
            distance = Mth.m_14008_((double)distance, (double)0.0, (double)maxDistance);
            float distanceFactor = (float)(distance / (double)maxDistance);
            float falloff = 1.0f - distanceFactor * distanceFactor;
            int ticksNew = Math.max(1, (int)((float)ticks * falloff));
            float strengthNew = strength * falloff;
            if (strengthNew > 0.0f && ticksNew > 0) {
                shakes.add(new ShakeInstance(strengthNew, ticksNew, groundCheck));
            }
        }
    }

    public static class ShakeInstance {
        public float strength;
        public int ticks;
        public boolean checkForGround;

        ShakeInstance(float strength, int ticks, boolean checkForGrounding) {
            this.strength = strength;
            this.ticks = ticks;
            this.checkForGround = checkForGrounding;
        }
    }
}

