/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animal.azure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.UUID;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.util.client.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import travelers.client.render.animal.azure.TravelersAzureAnimalPipeline;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersAzureModelRenderer
extends AzEntityModelRenderer<SmartAnimalBase> {
    private final TravelersAzureAnimalPipeline entityRendererPipeline;
    private TravelersClientAnimator animalAnimator = null;
    private boolean checkForAnimator = true;
    private boolean hasAnimator = false;
    private final Matrix4f poseState = new Matrix4f();
    private final Matrix4f localMatrix = new Matrix4f();
    private final Matrix4f tempMatrix = new Matrix4f();

    public TravelersAzureModelRenderer(TravelersAzureAnimalPipeline entityRendererPipeline, AzLayerRenderer<UUID, SmartAnimalBase> layerRenderer) {
        super((AzEntityRendererPipeline)entityRendererPipeline, layerRenderer);
        this.entityRendererPipeline = entityRendererPipeline;
    }

    public void render(AzRendererPipelineContext<UUID, SmartAnimalBase> context, boolean isReRender) {
        if (this.checkForAnimator) {
            this.getAnimalAnimator((SmartAnimalBase)context.animatable());
        }
        if (this.hasAnimator && !isReRender) {
            this.animalAnimator.beginFrame();
            this.animalAnimator.update((SmartAnimalBase)context.animatable(), context.partialTick());
        }
        super.render(context, isReRender);
    }

    public TravelersClientAnimator getAnimalAnimator(SmartAnimalBase base) {
        if (this.animalAnimator == null && this.checkForAnimator) {
            this.animalAnimator = TravelersAnimationMap.get(base);
            this.hasAnimator = this.animalAnimator != null;
            this.checkForAnimator = false;
        }
        return this.animalAnimator;
    }

    public void renderRecursively(AzRendererPipelineContext<UUID, SmartAnimalBase> context, AzBone bone, boolean isReRender) {
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        SmartAnimalBase entity = (SmartAnimalBase)context.animatable();
        PoseStack poseStack = context.poseStack();
        poseStack.m_85836_();
        TravelersBoneState boneState = null;
        if (this.hasAnimator && (boneState = this.animalAnimator.getCachedBoneState(bone.getName())) == null) {
            boneState = this.animalAnimator.updateAnimationOnBone(entity, bone.getName());
            this.animalAnimator.cacheBoneState(bone.getName(), boneState);
        }
        RenderUtils.translateMatrixToBone((PoseStack)poseStack, (AzBone)bone);
        if (boneState != null) {
            poseStack.m_252880_(boneState.offsetX / 16.0f, -boneState.offsetY / 16.0f, boneState.offsetZ / 16.0f);
        }
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (AzBone)bone);
        this.rotateMatrixAroundBone(poseStack, boneState, bone);
        RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (AzBone)bone);
        if (bone.isTrackingMatrices()) {
            this.poseState.set((Matrix4fc)poseStack.m_85850_().m_252922_());
            this.tempMatrix.set((Matrix4fc)RenderUtils.invertAndMultiplyMatrices((Matrix4f)this.poseState, (Matrix4f)this.entityRendererPipeline.getRenderTranslations()));
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)this.poseState, (Matrix4f)this.entityRendererPipeline.getModelRenderTranslations()));
            this.localMatrix.set((Matrix4fc)RenderUtils.translateMatrix((Matrix4f)this.tempMatrix, (Vector3f)this.entityRendererPipeline.getRenderer().m_7860_((Entity)entity, 1.0f).m_252839_()));
            bone.setLocalSpaceMatrix(this.localMatrix);
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)this.tempMatrix, (Vector3f)entity.m_20182_().m_252839_()));
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (AzBone)bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.m_85849_();
    }

    private void rotateMatrixAroundBone(PoseStack poseStack, TravelersBoneState boneState, AzBone bone) {
        float rx = bone.getRotX();
        float ry = bone.getRotY();
        float rz = bone.getRotZ();
        if (boneState != null) {
            rx += boneState.angleX;
            ry += boneState.angleY;
            rz += boneState.angleZ;
        }
        poseStack.m_252781_(Axis.f_252403_.m_252961_(rz));
        poseStack.m_252781_(Axis.f_252436_.m_252961_(ry));
        poseStack.m_252781_(Axis.f_252529_.m_252961_(rx));
    }
}

