/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersAnimationMap {
    private static final Map<TravelersAnimal<?>, TravelersClientAnimator> CLIENT_ANIMATORS = new ConcurrentHashMap();

    private TravelersAnimationMap() {
    }

    public static void register(TravelersAnimal<?> animal, TravelersClientAnimator animator) {
        if (animal != null && animator != null) {
            CLIENT_ANIMATORS.putIfAbsent(animal, animator);
        }
    }

    public static TravelersClientAnimator get(SmartAnimalBase animatable) {
        if (animatable == null) {
            return null;
        }
        TravelersAnimal<?> animal = animatable.getAnimal();
        return animal != null ? CLIENT_ANIMATORS.get(animal) : null;
    }

    public static void tick(SmartAnimalBase base) {
        if (base == null) {
            return;
        }
        TravelersClientAnimator animator = TravelersAnimationMap.get(base);
        if (animator != null) {
            animator.clientTick(base);
        }
    }
}

