/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersChainBuffer {
    private final TravelersAnimationData data;
    private int yawTimer;
    private float yawVariation;
    private float prevYawVariation;
    private float pitchVariation;
    private float prevPitchVariation;

    public TravelersChainBuffer(TravelersAnimationData jsAnimationData) {
        this.data = jsAnimationData;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, SmartAnimalBase entity) {
        if (this.data.physicsEnabled) {
            this.prevYawVariation = this.yawVariation;
            float deltaYaw = entity.f_20883_ - entity.f_20884_;
            if (deltaYaw != 0.0f && Math.abs(this.yawVariation) < maxAngle) {
                this.yawVariation += -deltaYaw / divisor;
            }
            if (Math.abs(this.yawVariation) > angleDecrement * 0.7f) {
                ++this.yawTimer;
                if (this.yawTimer > bufferTime) {
                    this.yawVariation *= 0.95f;
                    if (Math.abs(this.yawVariation) < 0.01f) {
                        this.yawVariation = 0.0f;
                        this.yawTimer = 0;
                    }
                }
            } else {
                this.yawTimer = 0;
            }
        } else if (this.yawVariation != 0.0f) {
            this.prevYawVariation = this.yawVariation;
            if (Math.abs(this.yawVariation) > angleDecrement * 0.7f) {
                ++this.yawTimer;
                if (this.yawTimer > bufferTime) {
                    this.yawVariation *= 0.95f;
                }
            } else {
                this.yawTimer = 0;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, SmartAnimalBase entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(float partialTick, List<TravelersBoneState> boneNames) {
        if (boneNames.isEmpty()) {
            return;
        }
        float interpolatedYaw = Mth.m_14179_((float)partialTick, (float)this.prevYawVariation, (float)this.yawVariation);
        float rotateAmount = interpolatedYaw * ((float)Math.PI / 180) / (float)boneNames.size();
        float fps = Minecraft.m_91087_().m_260875_();
        float t = Math.min(1.0f, 2.4f / Math.max(1.0f, fps));
        for (TravelersBoneState state : boneNames) {
            if (this.data.physicsEnabled) {
                state.angleY = Mth.m_14179_((float)t, (float)state.angleY, (float)(-rotateAmount));
                continue;
            }
            if (state.angleY == 0.0f) continue;
            state.angleY = Mth.m_14179_((float)t, (float)state.angleY, (float)0.0f);
            if (!(Math.abs(state.angleY) < 0.001f)) continue;
            state.angleY = 0.0f;
        }
    }

    public void applyChainWaveBuffer(float partialTick, List<TravelersBoneState> boneNames) {
        if (boneNames.isEmpty()) {
            return;
        }
        float interpolatedYaw = Mth.m_14179_((float)partialTick, (float)this.prevYawVariation, (float)this.yawVariation);
        float rotateAmount = interpolatedYaw * ((float)Math.PI / 180) / (float)boneNames.size();
        float fps = Minecraft.m_91087_().m_260875_();
        float t = Math.min(1.0f, 2.4f / Math.max(1.0f, fps));
        for (TravelersBoneState state : boneNames) {
            state.angleXo = state.angleX;
            if (this.data.physicsEnabled) {
                state.angleX = Mth.m_14179_((float)t, (float)state.angleX, (float)rotateAmount);
                continue;
            }
            if (state.angleX == 0.0f) continue;
            state.angleX = Mth.m_14179_((float)t, (float)state.angleX, (float)0.0f);
            if (!(Math.abs(state.angleX) < 0.001f)) continue;
            state.angleX = 0.0f;
        }
    }

    public void applyChainFlapBuffer(float partialTick, List<TravelersBoneState> boneNames) {
        if (boneNames.isEmpty()) {
            return;
        }
        float interpolatedYaw = Mth.m_14179_((float)partialTick, (float)this.prevYawVariation, (float)this.yawVariation);
        float rotateAmount = interpolatedYaw * ((float)Math.PI / 180) / (float)boneNames.size();
        float fps = Minecraft.m_91087_().m_260875_();
        float t = Math.min(1.0f, 2.4f / Math.max(1.0f, fps));
        for (TravelersBoneState state : boneNames) {
            if (this.data.physicsEnabled) {
                state.angleZ = Mth.m_14179_((float)t, (float)state.angleZ, (float)rotateAmount);
                continue;
            }
            if (state.angleZ == 0.0f) continue;
            state.angleZ = Mth.m_14179_((float)t, (float)state.angleZ, (float)0.0f);
            if (!(Math.abs(state.angleZ) < 0.001f)) continue;
            state.angleZ = 0.0f;
        }
    }
}

