/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersLegSolver {
    public final Leg[] legs;

    public TravelersLegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(SmartAnimalBase entity, float scale) {
        this.update(entity, entity.m_146908_(), scale);
    }

    public final void update(SmartAnimalBase entity, float yaw, float scale) {
        double radians = Math.toRadians(yaw);
        double sideX = Math.cos(radians) * (double)scale;
        double sideZ = Math.sin(radians) * (double)scale;
        double forwardX = Math.cos(radians + 1.5707963267948966) * (double)scale;
        double forwardZ = Math.sin(radians + 1.5707963267948966) * (double)scale;
        double posX = entity.m_20182_().f_82479_;
        double posY = entity.m_20182_().f_82480_;
        double posZ = entity.m_20182_().f_82481_;
        for (Leg leg : this.legs) {
            leg.update(entity, posX, posY, posZ, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side, float range) {
            this.forward = forward;
            this.side = side;
            this.range = range;
        }

        public final float getHeight(float delta) {
            return Mth.m_14179_((float)delta, (float)this.prevHeight, (float)this.height);
        }

        public void update(SmartAnimalBase entity, double baseX, double baseY, double baseZ, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double targetX = baseX + sideX * (double)this.side + forwardX * (double)this.forward;
            double targetZ = baseZ + sideZ * (double)this.side + forwardZ * (double)this.forward;
            double targetY = baseY;
            float settledHeight = this.settle(entity, targetX, targetY, targetZ, this.height, scale);
            this.height = Mth.m_14036_((float)settledHeight, (float)(-this.range * scale), (float)(this.range * scale));
        }

        private float settle(SmartAnimalBase entity, double x, double y, double z, float currentHeight, float scale) {
            Level level = entity.m_9236_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.m_122169_(x, y, z);
            double localY = y - Math.floor(y);
            float surfaceOffset = this.getSurfaceOffset(entity, level, (BlockPos)pos);
            if ((double)surfaceOffset >= 0.999) {
                pos.m_142448_(pos.m_123342_() - 1);
                surfaceOffset = this.getSurfaceOffset(entity, level, (BlockPos)pos) + (float)localY;
            } else {
                surfaceOffset -= 1.0f - (float)localY;
            }
            if (entity.m_20096_()) {
                return surfaceOffset;
            }
            return 0.0f;
        }

        private float getSurfaceOffset(SmartAnimalBase entity, Level level, BlockPos pos) {
            BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
            int depth = (int)Math.floor(entity.m_20206_() / 3.0f);
            if (depth < 1) {
                depth = 1;
            }
            float accumulatedDepth = 0.0f;
            for (int i = 0; i < depth; ++i) {
                BlockPos newPos = mutableBlockPos.m_6625_(i);
                BlockState state = level.m_8055_(newPos);
                VoxelShape shape = state.m_60812_((BlockGetter)level, newPos);
                if (shape.m_83281_()) {
                    accumulatedDepth += 1.0f;
                    continue;
                }
                accumulatedDepth += (float)(1.0 - shape.m_83297_(Direction.Axis.Y));
                break;
            }
            return accumulatedDepth;
        }
    }
}

