/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal;

import com.google.common.base.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import travelers.server.animal.ModelType;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.obj.TravelersAnimalAttributes;
import travelers.server.animal.obj.TravelersItemInterface;
import travelers.server.animal.obj.TravelersMoveAnalysis;
import travelers.server.animal.obj.attributes.EntityAttributeProperties;

public class TravelersAnimal<T extends SmartAnimalBase> {
    private final TravelersAnimalAttributes<T> animalAttributes;
    private TravelersItemInterface<T> items;
    private ModelType modelType = ModelType.AZURE;
    private Supplier<EntityType<? extends Entity>> entityType;

    public TravelersAnimal(TravelersAnimalAttributes<T> animalAttributes) {
        this.animalAttributes = animalAttributes;
        if (animalAttributes.getEntityBaseProperties().getLocator() != null) {
            animalAttributes.getEntityBaseProperties().getLocator().setModId(animalAttributes.getModId());
        }
    }

    public void animate(SmartAnimalBase base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
    }

    public void animateServer(SmartAnimalBase base, TravelersMoveAnalysis moveAnalysis, TravelersAnimalAnimationModule animationManager) {
    }

    public void setItemInterface(TravelersItemInterface<T> itemInterface) {
        this.items = itemInterface;
    }

    public AttributeSupplier.Builder createAnimalAttributes() {
        return SmartAnimalBase.m_21552_().m_22268_(Attributes.f_22276_, this.getAnimalAttributes().getEntityAttributeProperties().getMaxHealth()).m_22268_(Attributes.f_22281_, this.getAnimalAttributes().getEntityAttributeProperties().getAttackDamage()).m_22268_(Attributes.f_22283_, this.getAnimalAttributes().getEntityAttributeProperties().getAttackSpeed()).m_22268_(Attributes.f_22279_, this.getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed()).m_22268_(Attributes.f_22277_, this.getAnimalAttributes().getEntityAttributeProperties().getTrackingRange()).m_22268_(Attributes.f_22280_, this.getAnimalAttributes().getEntityAttributeProperties().getFlyingSpeed());
    }

    public final Supplier<EntityType<?>> buildType() {
        if (this.entityType != null) {
            return this.entityType;
        }
        return () -> {
            EntityAttributeProperties<T> entityAttributes = this.animalAttributes.getEntityAttributeProperties();
            EntityType.Builder builder = EntityType.Builder.m_20704_(entityAttributes.getEntityFactory(), (MobCategory)entityAttributes.getCategory()).m_20699_((float)entityAttributes.getDimensions()[0], (float)entityAttributes.getDimensions()[1]);
            if (entityAttributes.isSpawnFar()) {
                builder.m_20720_();
            }
            builder.m_20702_((int)entityAttributes.getTrackingRange());
            this.extraTypeArguments(builder, this.animalAttributes);
            builder.m_20702_((int)entityAttributes.getTrackingRange());
            return builder.m_20712_(this.animalAttributes.getModId() + ":" + this.animalAttributes.getAnimalName());
        };
    }

    protected void extraTypeArguments(EntityType.Builder<T> builder, TravelersAnimalAttributes<T> animalAttributes) {
    }

    public TravelersAnimalAttributes<T> getAnimalAttributes() {
        return this.animalAttributes;
    }

    public TravelersItemInterface<T> getItems() {
        return this.items;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public Supplier<EntityType<? extends Entity>> getEntityType() {
        return this.entityType;
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public void setEntityType(Supplier<EntityType<? extends Entity>> entityType) {
        this.entityType = entityType;
    }
}

