/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.entity.other.TravelersBodyRotationControl;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.vanilla.EmptyMoveControl;
import travelers.server.animal.entity.pathingsystem.vanilla.EmptyNavigation;
import travelers.server.animal.entity.task.TravelerTaskController;
import travelers.server.animal.obj.IAnimalHolder;
import travelers.server.animal.obj.TravelersMoveAnalysis;

public abstract class SmartAnimalBase
extends PathfinderMob
implements IAnimalHolder {
    protected final TravelersMoveAnalysis moveAnalysis;
    private final Map<TravelersPathType, Float> pathfindingMalus = Maps.newEnumMap(TravelersPathType.class);
    private final TravelersAnimal<?> animal;
    protected TravelersMoveControl moveController;
    protected TravelersPathNavigation navigationController;
    protected boolean freezeAnimator;
    private TravelerTaskController taskController;
    private TravelerTaskController combatController;
    private TravelersAnimalAnimationModule animationModule;
    private float previousYaw = 0.0f;
    private double curSpeed = 0.0;

    public SmartAnimalBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        ResourceLocation id = EntityType.m_20613_(entityType);
        this.animal = TravelersAnimalRegistry.getAnimalFromType(id.m_135827_(), entityType);
        if (this.animal == null) {
            throw new RuntimeException("No Animal Found for " + String.valueOf(entityType));
        }
        if (this.animal.getAnimalAttributes().getEntityAttributeProperties().isPersistent()) {
            this.m_21530_();
        }
        this.f_21342_ = new EmptyMoveControl((Mob)this);
        this.moveAnalysis = new TravelersMoveAnalysis(this, 2);
        this.navigationController = this.createNavigationController(level);
        if (!level.f_46443_) {
            this.addTasksToController(this.getTaskController(), this.getCombatTargeting());
        }
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new TravelersBodyRotationControl(this);
    }

    public float m_6113_() {
        double speed = 0.0;
        double baseSpeed = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
        float scale = this.m_6134_();
        if (scale != 1.0f) {
            baseSpeed /= (double)scale;
        }
        float currentYaw = this.m_146908_();
        float turningAmount = Math.abs(currentYaw - this.previousYaw);
        turningAmount = (turningAmount + 180.0f) % 360.0f - 180.0f;
        if ((turningAmount = Math.abs(turningAmount)) > 5.0f) {
            float turnSlowdown = Math.min(1.0f, turningAmount / 90.0f);
            baseSpeed *= (double)(1.0f - 0.3f * turnSlowdown);
        }
        if (this.isRunning()) {
            speed = Mth.m_14139_((double)0.1, (double)this.curSpeed, (double)(baseSpeed * this.animal.getAnimalAttributes().getEntityAttributeProperties().getRunningSpeedMultiplier()));
        } else if (this.m_20069_()) {
            speed = Mth.m_14139_((double)0.1, (double)this.curSpeed, (double)(baseSpeed * this.animal.getAnimalAttributes().getEntityAttributeProperties().getSwimmingSpeedMultiplier() * this.animal.getAnimalAttributes().getEntityAttributeProperties().getWaterEfficiency()));
        } else if (this.getNavigationController().isInProgress()) {
            speed = Mth.m_14139_((double)0.1, (double)this.curSpeed, (double)baseSpeed);
        }
        this.previousYaw = currentYaw;
        this.curSpeed = speed;
        return (float)speed;
    }

    public boolean isRunning() {
        return !(!this.m_5912_() && !this.isPanicking() || this.m_20069_() && !this.canRunInWater());
    }

    public boolean isPanicking() {
        return false;
    }

    protected abstract boolean canRunInWater();

    protected abstract TravelersPathNavigation createNavigationController(Level var1);

    public float m_5610_(@NotNull BlockPos pos, @NotNull LevelReader level) {
        return this.isAnimal() ? (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) ? 10.0f : level.m_220419_(pos)) : super.m_5610_(pos, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.moveAnalysis.update();
        if (this.m_9236_().f_46443_) {
            this.clientTick();
        }
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
    }

    private void clientTick() {
        if (!this.freezeAnimator) {
            this.animal.animate(this, this.moveAnalysis, this.getAnimationModule());
        } else {
            this.freezeAnimator = false;
        }
        TravelersAnimationMap.tick(this);
    }

    public boolean isAnimal() {
        return false;
    }

    public void m_21441_(@NotNull BlockPathTypes nodeType, float malus) {
    }

    public void setPathfindingMalus(TravelersPathType pathType, float malus) {
        this.pathfindingMalus.put(pathType, Float.valueOf(malus));
    }

    public float getPathfindingMalus(TravelersPathType pathType) {
        Float f = this.pathfindingMalus.get((Object)pathType);
        return f == null ? pathType.getMalus() : f.floatValue();
    }

    protected final void m_8099_() {
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new EmptyNavigation((Mob)this, this.m_9236_());
    }

    public void m_8107_() {
        super.m_8107_();
    }

    protected void m_8024_() {
        this.getTaskController().tickController();
        this.getCombatTargeting().tickController();
        if (this.moveController != null) {
            this.moveController.tick();
        }
        if (this.navigationController != null) {
            this.navigationController.tick();
        }
        if (!this.freezeAnimator) {
            this.animal.animateServer(this, this.moveAnalysis, this.getAnimationModule());
        } else {
            this.freezeAnimator = false;
        }
    }

    public void stopInPlace() {
        this.getNavigationController().stop();
        this.m_21570_(0.0f);
        this.m_21567_(0.0f);
        this.m_7910_(0.0f);
    }

    public boolean avoidsLight() {
        return false;
    }

    public TravelerTaskController getTaskController() {
        if (this.taskController == null) {
            this.taskController = new TravelerTaskController();
        }
        return this.taskController;
    }

    public TravelerTaskController getCombatTargeting() {
        if (this.combatController == null) {
            this.combatController = new TravelerTaskController();
        }
        return this.combatController;
    }

    public double jumpHeight() {
        return this.m_274421_();
    }

    public boolean canMove() {
        return true;
    }

    public boolean isAmphibian() {
        return false;
    }

    @Override
    public TravelersAnimal<?> getAnimal() {
        return this.animal;
    }

    public float getTurnMultiplier() {
        return 1.0f;
    }

    public float m_6134_() {
        return 1.0f;
    }

    public TravelersAnimalAnimationModule getAnimationModule() {
        if (this.animationModule == null) {
            this.animationModule = new TravelersAnimalAnimationModule(this);
        }
        return this.animationModule;
    }

    public float getRenderScale() {
        return (float)this.getAnimal().getAnimalAttributes().getEntityBaseProperties().getRenderScale();
    }

    public double climbHeight() {
        return 10.0;
    }

    public TravelersMoveAnalysis getMoveAnalysis() {
        return this.moveAnalysis;
    }

    public TravelersMoveControl getMoveController() {
        return this.moveController;
    }

    public void setMoveController(TravelersMoveControl moveController) {
        this.moveController = moveController;
    }

    public TravelersPathNavigation getNavigationController() {
        return this.navigationController;
    }

    public void setNavigationController(TravelersPathNavigation navigationController) {
        this.navigationController = navigationController;
    }

    public void setFreezeAnimator(boolean freezeAnimator) {
        this.freezeAnimator = freezeAnimator;
    }
}

