/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.other;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersBodyRotationControl
extends BodyRotationControl {
    private final SmartAnimalBase mob;
    private int headStableTime;
    private float rotationSpeed = -1.0f;

    public TravelersBodyRotationControl(SmartAnimalBase mob) {
        super((Mob)mob);
        this.mob = mob;
    }

    public void m_8121_() {
        if (this.mob.m_5803_()) {
            return;
        }
        if (this.m_24884_()) {
            this.mob.f_20883_ = this.lerpRotation(this.mob.f_20883_, this.mob.m_146908_(), this.getTurnSpeed());
            this.m_24881_();
            this.headStableTime = 0;
        } else {
            ++this.headStableTime;
            if (this.headStableTime > 10) {
                this.rotateHeadTowardsFrontSmooth();
            }
        }
    }

    protected float getTurnSpeed() {
        if (this.mob.getAnimal() == null) {
            return 1.0f;
        }
        float TURN = (float)this.mob.getAnimal().getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
        double progressPercentage = this.mob.m_6134_();
        if (progressPercentage < 1.0) {
            TURN *= (float)Mth.m_14139_((double)progressPercentage, (double)2.0, (double)1.0);
        }
        this.rotationSpeed = TURN / 10.0f;
        return this.rotationSpeed;
    }

    private void m_24881_() {
        float targetAngle = this.mob.f_20883_;
        float maxRotation = this.mob.m_8085_();
        this.mob.f_20885_ = this.smoothRotate(this.mob.f_20885_, targetAngle, maxRotation, this.getTurnSpeed());
    }

    private void rotateHeadTowardsFrontSmooth() {
        int i = this.headStableTime - 10;
        float progress = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
        float maxRotation = (float)this.mob.m_8085_() * (1.0f - progress);
        this.mob.f_20883_ = this.smoothRotate(this.mob.f_20883_, this.mob.f_20885_, maxRotation, this.getTurnSpeed());
    }

    private boolean m_24884_() {
        double dz;
        double dx = this.mob.m_20185_() - this.mob.f_19854_;
        return dx * dx + (dz = this.mob.m_20189_() - this.mob.f_19856_) * dz > (double)2.5E-7f;
    }

    private float lerpRotation(float current, float target, float speed) {
        float diff = this.wrapDegrees(target - current);
        return current + diff * speed;
    }

    private float smoothRotate(float current, float target, float maxRotation, float speed) {
        float diff = this.wrapDegrees(target - current);
        diff = Mth.m_14036_((float)diff, (float)(-maxRotation), (float)maxRotation);
        return this.lerpRotation(current, current + diff, speed);
    }

    private float wrapDegrees(float degrees) {
        if ((degrees %= 360.0f) >= 180.0f) {
            degrees -= 360.0f;
        }
        if (degrees < -180.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }
}

