/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.util.Mth;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;

public class TravelersFlyingMoveControl
extends TravelersMoveControl {
    private final float maxTurn;
    private final boolean hoversInPlace;

    public TravelersFlyingMoveControl(SmartAnimalBase mob, TravelersAnimal<?> animal, boolean hoversInPlace) {
        super(mob, animal);
        this.hoversInPlace = hoversInPlace;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
    }

    @Override
    public void tick() {
        if (!this.mob.canMove()) {
            return;
        }
        if (this.operation == TravelersMoveControl.Operation.MOVE_TO && this.mob.getNavigationController().isInProgress()) {
            double deltaZ;
            double deltaY;
            double deltaX = this.wantedX - this.mob.m_20185_();
            double totalDeltaSqr = deltaX * deltaX + (deltaY = this.wantedY - this.mob.m_20186_()) * deltaY + (deltaZ = this.wantedZ - this.mob.m_20189_()) * deltaZ;
            if (totalDeltaSqr < 2.5E-7) {
                this.mob.m_21564_(0.0f);
            } else {
                double horizDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                float moveSpeed = this.mob.m_6113_();
                if (Math.abs(deltaY) > horizDist * 1.5) {
                    this.mob.m_7910_(0.0f);
                    this.mob.m_21564_(0.0f);
                    this.mob.m_21570_(0.0f);
                    this.mob.m_21567_(deltaY > 0.0 ? moveSpeed : -moveSpeed);
                    return;
                }
                if (Math.abs(deltaY) < horizDist * 1.5) {
                    float targetYaw = (float)(Mth.m_14136_((double)deltaZ, (double)deltaX) * 180.0 / Math.PI) - 90.0f;
                    float smoothedYaw = this.rotlerp(this.mob.m_146908_(), targetYaw, this.maxTurn);
                    this.mob.m_146922_(smoothedYaw);
                    this.mob.f_20883_ = smoothedYaw;
                    this.mob.f_20885_ = smoothedYaw;
                }
                if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(horizDist) > (double)1.0E-5f) {
                    float targetPitch = -((float)(Mth.m_14136_((double)deltaY, (double)horizDist) * 180.0 / Math.PI));
                    targetPitch = Mth.m_14036_((float)Mth.m_14177_((float)targetPitch), (float)(-this.maxTurn), (float)this.maxTurn);
                    float smoothedPitch = this.rotlerp(this.mob.m_146909_(), targetPitch, this.maxTurn);
                    this.mob.m_146926_(smoothedPitch);
                }
                this.mob.m_7910_(moveSpeed);
                this.mob.m_21567_(deltaY > 0.0 ? moveSpeed * 0.6f : -moveSpeed * 0.6f);
            }
        } else {
            this.mob.m_7910_(0.0f);
            if (this.hoversInPlace) {
                this.mob.m_21567_(0.0f);
                this.mob.m_21564_(0.0f);
                this.mob.m_21570_(0.0f);
            } else {
                this.mob.m_21567_(Mth.m_14179_((float)0.1f, (float)this.mob.f_20901_, (float)0.0f));
                this.mob.m_21564_(Mth.m_14179_((float)0.1f, (float)this.mob.f_20902_, (float)0.0f));
                this.mob.m_21570_(Mth.m_14179_((float)0.1f, (float)this.mob.f_20900_, (float)0.0f));
            }
        }
    }
}

