/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.control.Control;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.util.TravelersUtil;

public class TravelersMoveControl
implements Control {
    protected final float maxTurn;
    protected final float turnSmoothRate;
    protected final SmartAnimalBase mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected Operation operation = Operation.WAIT;

    public TravelersMoveControl(SmartAnimalBase pMob, TravelersAnimal<?> animal) {
        this.mob = pMob;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
        this.turnSmoothRate = (float)animal.getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
    }

    public void setWantedPosition(double x, double y, double z, double speed) {
        this.wantedX = x;
        this.wantedY = y;
        this.wantedZ = z;
        this.speedModifier = speed;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void tick() {
        switch (this.operation) {
            case MOVE_TO: {
                this.handleMoveTo();
                break;
            }
            case JUMPING: {
                this.handleJumping();
                break;
            }
            default: {
                this.mob.m_21564_(0.0f);
            }
        }
    }

    protected void handleMoveTo() {
        double dz;
        double dy;
        double dx = this.wantedX - this.mob.m_20185_();
        double distSq = dx * dx + (dy = this.wantedY - this.mob.m_20186_()) * dy + (dz = this.wantedZ - this.mob.m_20189_()) * dz;
        if (distSq < 2.5E-7) {
            this.mob.m_21564_(0.0f);
            this.operation = Operation.WAIT;
            return;
        }
        float targetAngle = (float)(Mth.m_14136_((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f;
        this.mob.m_146922_(this.rotlerp(this.mob.m_146908_(), targetAngle, this.getTurnSpeed()));
        this.mob.m_5618_(this.mob.m_146908_());
        this.mob.m_7910_((float)(this.speedModifier * (double)this.mob.m_6113_()));
        if (this.shouldJump(dy, dx, dz)) {
            this.mob.m_21569_().m_24901_();
            this.operation = Operation.JUMPING;
        }
    }

    protected void handleJumping() {
        this.mob.m_7910_((float)(this.speedModifier * (double)this.mob.m_6113_()));
        if (this.mob.m_20096_()) {
            this.operation = Operation.WAIT;
        }
    }

    protected boolean shouldJump(double dy, double dx, double dz) {
        double dist = this.mob.m_20275_(this.mob.m_20185_() + dx, this.mob.m_20186_(), this.mob.m_20189_() + dz);
        if (dist < (double)(this.mob.m_20205_() * 1.1f)) {
            boolean collides;
            boolean bl = collides = !TravelersUtil.noBlockCollisions(this.mob, this.mob.m_20191_().m_82363_(0.0, dy, 0.0));
            if (collides) {
                return false;
            }
            return dy > (double)this.mob.m_274421_() && dy <= this.mob.jumpHeight();
        }
        return false;
    }

    protected float rotlerp(float from, float to, float maxTurn) {
        float delta = Mth.m_14177_((float)(to - from));
        float limited = Mth.m_14036_((float)delta, (float)(-maxTurn), (float)maxTurn);
        return from + limited;
    }

    protected float getTurnSpeed() {
        float v = this.maxTurn;
        float mult = this.mob.getTurnMultiplier();
        if (mult > 0.0f && mult != 1.0f) {
            v *= mult;
        }
        return v;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public static enum Operation {
        WAIT,
        MOVE_TO,
        JUMPING;

    }
}

