/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.util.Mth;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;

public class TravelersSmoothSwimMoveControl
extends TravelersMoveControl {
    protected final float maxTurnX;
    protected final float maxTurnY;
    protected final float inWaterSpeedModifier;
    protected final float outsideWaterSpeedModifier;
    protected final boolean forceFloat;

    public TravelersSmoothSwimMoveControl(SmartAnimalBase pMob, float maxTurnX, float maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
        super(pMob, pMob.getAnimal());
        this.maxTurnX = maxTurnX;
        this.maxTurnY = maxTurnY;
        this.inWaterSpeedModifier = inWaterSpeedModifier;
        this.outsideWaterSpeedModifier = outsideWaterSpeedModifier;
        this.forceFloat = applyGravity;
    }

    @Override
    public void setWantedPosition(double pX, double pY, double pZ, double pSpeed) {
        super.setWantedPosition(pX, pY, pZ, pSpeed);
    }

    @Override
    public void tick() {
        if (!this.mob.m_20069_() && this.mob.isAmphibian()) {
            super.tick();
            return;
        }
        if (this.forceFloat && this.mob.m_20069_() && !this.mob.m_20068_()) {
            this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, 0.005, 0.0));
        }
        if (this.operation == TravelersMoveControl.Operation.MOVE_TO && !this.mob.getNavigationController().isDone()) {
            double dz;
            double dy;
            double dx = this.wantedX - this.mob.m_20185_();
            double distSqr = dx * dx + (dy = this.wantedY - this.mob.m_20186_()) * dy + (dz = this.wantedZ - this.mob.m_20189_()) * dz;
            if (distSqr < 2.5E-7) {
                this.mob.m_21564_(0.0f);
            } else {
                double horizDist = Math.sqrt(dx * dx + dz * dz);
                if (Math.abs(dy) < horizDist * 1.5) {
                    float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float smoothedYaw = Mth.m_14189_((float)this.turnSmoothRate, (float)this.mob.m_146908_(), (float)targetYaw);
                    this.mob.m_146922_(smoothedYaw);
                    this.mob.f_20883_ = smoothedYaw;
                    this.mob.f_20885_ = smoothedYaw;
                }
                this.mob.m_7910_(this.mob.m_6113_());
                if (this.mob.m_20069_()) {
                    if (Math.abs(dy) > horizDist * 1.5) {
                        this.mob.m_21564_(0.0f);
                        this.mob.m_7910_(0.0f);
                        this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, Math.signum(dy) * 0.02, 0.0));
                        return;
                    }
                    if (Math.abs(dy) > 0.05 || horizDist > 1.0E-5) {
                        float targetPitch = -((float)(Mth.m_14136_((double)dy, (double)horizDist) * 57.29577951308232));
                        float clampedPitch = Mth.m_14036_((float)Mth.m_14177_((float)targetPitch), (float)(-this.maxTurn), (float)this.maxTurn);
                        float currentPitch = this.mob.m_146909_();
                        float smoothedPitch = currentPitch + 0.15f * (clampedPitch - currentPitch);
                        this.mob.m_146926_(smoothedPitch);
                    }
                }
            }
        } else {
            this.mob.m_7910_(0.0f);
            this.mob.m_21570_(0.0f);
            this.mob.m_21567_(0.0f);
            this.mob.m_21564_(0.0f);
        }
    }
}

