/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersSwimNodeEvaluator;
import travelers.util.TravelersUtil;

public class TravelersAquaticNavigation
extends TravelersPathNavigation {
    private final boolean allowBreaching;
    private final SmartAnimalBase base;

    public TravelersAquaticNavigation(SmartAnimalBase mob, Level level, boolean allowBreaching) {
        super(mob, level);
        this.base = mob;
        this.allowBreaching = allowBreaching;
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, SmartAnimalBase mob, Vec3 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        Vec3 nodeCenter = Vec3.m_82512_((Vec3i)path.getNodePos(nextNodeIndex));
        Vec3 pos = mob.m_20182_();
        return TravelersUtil.closerThan(nodeCenter, pos, Math.max(0.75, (double)(mob.m_20205_() / 2.0f)), Math.max(0.75f, mob.m_20206_()));
    }

    @Override
    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.m_20069_();
    }

    @Override
    protected double getGroundY(Vec3 vec) {
        return vec.f_82480_;
    }

    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.m_20185_(), this.mob.m_20227_(0.5), this.mob.m_20189_());
    }

    @Override
    public boolean isStableDestination(BlockPos pos) {
        return !this.level.m_8055_(pos).m_60804_((BlockGetter)this.level, pos);
    }

    @Override
    public void setCanFloat(boolean canSwim) {
    }

    @Override
    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

