/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.navigation.obj.TravelersGenericNav;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;

public class TravelersGroundNavigation
extends TravelersPathNavigation {
    private final SmartAnimalBase base;
    private final int recomputeTick = 0;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public TravelersGroundNavigation(SmartAnimalBase mob, Level level) {
        super(mob, level);
        this.base = mob;
    }

    @Override
    protected boolean canUpdatePath() {
        return this.mob.m_20096_() || this.mob.m_20069_() || this.mob.m_20159_();
    }

    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.m_20185_(), (double)this.getSurfaceY(), this.mob.m_20189_());
    }

    @Override
    protected void trimPath() {
        super.trimPath();
    }

    @Override
    public CompletableFuture<TravelersPath> createPath(BlockPos pos, double accuracy) {
        LevelChunk levelchunk = this.level.m_7726_().m_7131_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
        if (levelchunk == null) {
            return null;
        }
        if (levelchunk.m_8055_(pos).m_60795_()) {
            BlockPos blockpos = pos.m_7495_();
            while (blockpos.m_123342_() > this.level.m_141937_() && levelchunk.m_8055_(blockpos).m_60795_()) {
                blockpos = blockpos.m_7495_();
            }
            if (blockpos.m_123342_() > this.level.m_141937_()) {
                return super.createPath(blockpos.m_7494_(), accuracy);
            }
            while (blockpos.m_123342_() < this.level.m_151558_() && levelchunk.m_8055_(blockpos).m_60795_()) {
                blockpos = blockpos.m_7494_();
            }
            pos = blockpos;
        }
        if (!levelchunk.m_8055_(pos).m_280296_()) {
            return super.createPath(pos, accuracy);
        }
        BlockPos blockpos1 = pos.m_7494_();
        while (blockpos1.m_123342_() < this.level.m_151558_() && levelchunk.m_8055_(blockpos1).m_280296_()) {
            blockpos1 = blockpos1.m_7494_();
        }
        return super.createPath(blockpos1, accuracy);
    }

    @Override
    public CompletableFuture<TravelersPath> createPath(Entity entity, int accuracy) {
        return this.createPath(entity.m_20183_(), (double)accuracy);
    }

    private int getSurfaceY() {
        if (this.mob.m_20069_() && this.canFloat()) {
            int i = this.mob.m_146904_();
            BlockState blockstate = this.level.m_8055_(BlockPos.m_274561_((double)this.mob.m_20185_(), (double)i, (double)this.mob.m_20189_()));
            int j = 0;
            while (blockstate.m_60713_(Blocks.f_49990_)) {
                blockstate = this.level.m_8055_(BlockPos.m_274561_((double)this.mob.m_20185_(), (double)(++i), (double)this.mob.m_20189_()));
                if (++j <= 16) continue;
                return this.mob.m_146904_();
            }
            return i;
        }
        return Mth.m_14107_((double)(this.mob.m_20186_() + 0.5));
    }

    @Override
    public boolean isStableDestination(BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState state = this.level.m_8055_(blockpos);
        if (this.base.m_20069_()) {
            if (state.m_60819_().m_76178_()) {
                return state.m_60804_((BlockGetter)this.level, blockpos);
            }
            return !state.m_60804_((BlockGetter)this.level, blockpos);
        }
        return state.m_60804_((BlockGetter)this.level, blockpos);
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (TravelersGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            this.path.advance();
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    @Override
    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersWalkNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.isCanPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.isCanOpenDoors();
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.nodeEvaluator.setCanWalkOverFences(canWalkOverFences);
    }

    public boolean avoidsLight() {
        return ((TravelersWalkNodeEvaluator)this.nodeEvaluator).isTriesToAvoidLight();
    }
}

