/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersAmphibiousNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private final boolean prefersShallowSwimming;
    private float oldWalkableCost;
    private float oldWaterBorderCost;
    private final BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos tmp2 = new BlockPos.MutableBlockPos();

    public TravelersAmphibiousNodeEvaluator(boolean prefersShallowSwimming) {
        this.prefersShallowSwimming = prefersShallowSwimming;
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersAmphibiousNodeEvaluator nodeEvaluator = new TravelersAmphibiousNodeEvaluator(this.prefersShallowSwimming);
        this.applyDefaultProperties(nodeEvaluator);
        nodeEvaluator.setCanClimb(this.isCanClimb());
        nodeEvaluator.setCanClimbAnyBlock(this.isCanClimbAnyBlock());
        return nodeEvaluator;
    }

    @Override
    public void prepare(@NotNull PathNavigationRegion level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        mob.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.oldWalkableCost = mob.getPathfindingMalus(TravelersPathType.WALKABLE);
        mob.setPathfindingMalus(TravelersPathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = mob.getPathfindingMalus(TravelersPathType.WATER_BORDER);
        mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, 4.0f);
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.setPathfindingMalus(TravelersPathType.WALKABLE, this.oldWalkableCost);
            this.mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, this.oldWaterBorderCost);
        }
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        return !this.mob.m_20069_() ? super.getStart() : this.getInnerStart();
    }

    @NotNull
    private TravelersNode getInnerStart() {
        AABB box = this.mob.m_20191_();
        double centerX = (box.f_82288_ + box.f_82291_) * 0.5;
        double centerY = (box.f_82289_ + box.f_82292_) * 0.5;
        double centerZ = (box.f_82290_ + box.f_82293_) * 0.5;
        int y = Mth.m_14107_((double)centerY);
        this.tmp.m_122169_(centerX, (double)y, centerZ);
        BlockState state = this.context.getBlockState((BlockPos)this.tmp);
        if (!state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            boolean found = false;
            for (int dy = 1; dy <= 6; ++dy) {
                this.tmp.m_122169_(centerX, (double)(y - dy), centerZ);
                if (this.context.getBlockState((BlockPos)this.tmp).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                    y -= dy;
                    found = true;
                    break;
                }
                this.tmp.m_122169_(centerX, (double)(y + dy), centerZ);
                if (!this.context.getBlockState((BlockPos)this.tmp).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                y += dy;
                found = true;
                break;
            }
            if (!found) {
                y = Mth.m_14107_((double)this.mob.m_20186_());
            }
        }
        this.tmp.m_142448_(y);
        return this.getNode((BlockPos)this.tmp);
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y + 0.5, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        int i = super.getNeighbors(outputArray, p_node);
        TravelersPathType above = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType at = this.getPathType(p_node.x, p_node.y, p_node.z);
        int stepAllowance = this.mob.getPathfindingMalus(above) >= 0.0f && at != TravelersPathType.STICKY_HONEY ? Mth.m_14143_((float)Math.max(1.0f, this.mob.m_274421_())) : 0;
        this.tmp.m_122178_(p_node.x, p_node.y, p_node.z);
        double floorY = this.getFloorLevel((BlockPos)this.tmp);
        TravelersNode up = this.findAcceptedNode(p_node, p_node.x, p_node.y + 1, p_node.z, Math.max(0, stepAllowance - 1), floorY, Direction.UP, at);
        TravelersNode down = this.findAcceptedNode(p_node, p_node.x, p_node.y - 1, p_node.z, stepAllowance, floorY, Direction.DOWN, at);
        if (this.isVerticalNeighborValid(up, p_node)) {
            outputArray[i++] = up;
        }
        if (this.isVerticalNeighborValid(down, p_node) && at != TravelersPathType.TRAPDOOR) {
            outputArray[i++] = down;
        }
        if (this.prefersShallowSwimming) {
            int sea = this.mob.m_9236_().m_5736_();
            for (int k = 0; k < i; ++k) {
                TravelersNode n = outputArray[k];
                if (n == null || n.type != TravelersPathType.WATER || n.y >= sea - 10) continue;
                n.costMalus += 1.0f;
            }
        }
        return i;
    }

    private boolean isVerticalNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && this.isNeighborValid(neighbor, node) && neighbor.type == TravelersPathType.WATER;
    }

    @Override
    protected boolean isAmphibious() {
        return this.isCanFloat();
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        TravelersPathType at = context.getPathTypeFromState(x, y, z);
        if (at == TravelersPathType.WATER) {
            for (Direction dir : Direction.values()) {
                this.tmp2.m_122178_(x, y, z).m_122173_(dir);
                TravelersPathType adj = context.getPathTypeFromState(this.tmp2.m_123341_(), this.tmp2.m_123342_(), this.tmp2.m_123343_());
                if (adj != TravelersPathType.BLOCKED) continue;
                return TravelersPathType.WATER_BORDER;
            }
            return TravelersPathType.WATER;
        }
        return super.getPathType(context, x, y, z);
    }
}

