/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersSwimNodeEvaluator
extends TravelersNodeEvaluator {
    private final boolean allowBreaching;
    private final Long2ObjectMap<TravelersPathType> pathTypeCache = new Long2ObjectOpenHashMap();
    private final BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();

    public TravelersSwimNodeEvaluator(boolean allowBreaching) {
        this.allowBreaching = allowBreaching;
    }

    private static boolean hasMalus(@Nullable TravelersNode node) {
        return node != null && node.costMalus >= 0.0f;
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersSwimNodeEvaluator nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        this.applyDefaultProperties(nodeEvaluator);
        return nodeEvaluator;
    }

    @Override
    public void prepare(@NotNull PathNavigationRegion level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.pathTypeCache.clear();
    }

    @Override
    public void done() {
        super.done();
        this.pathTypeCache.clear();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        AABB box = this.mob.m_20191_();
        double cx = (box.f_82288_ + box.f_82291_) * 0.5;
        double cy = (box.f_82289_ + box.f_82292_) * 0.5;
        double cz = (box.f_82290_ + box.f_82293_) * 0.5;
        int y = Mth.m_14107_((double)cy);
        this.temp.m_122169_(cx, (double)y, cz);
        BlockState state = this.context.getBlockState((BlockPos)this.temp);
        if (!state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            boolean found = false;
            for (int dy = 1; dy <= 6; ++dy) {
                if (this.context.getBlockState((BlockPos)this.temp.m_122169_(cx, (double)(y - dy), cz)).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                    y -= dy;
                    found = true;
                    break;
                }
                if (!this.context.getBlockState((BlockPos)this.temp.m_122169_(cx, (double)(y + dy), cz)).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                y += dy;
                found = true;
                break;
            }
            if (!found) {
                y = Mth.m_14107_((double)this.mob.m_20186_());
            }
        }
        this.temp.m_142448_(y);
        return this.getNode((BlockPos)this.temp);
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, @NotNull TravelersNode current) {
        int i = 0;
        EnumMap<Direction, TravelersNode> neighbors = new EnumMap<Direction, TravelersNode>(Direction.class);
        for (Direction dir : Direction.values()) {
            TravelersNode n = this.findAcceptedNode(current.x + dir.m_122429_(), current.y + dir.m_122430_(), current.z + dir.m_122431_());
            neighbors.put(dir, n);
            if (!this.isNodeValid(n)) continue;
            outputArray[i++] = n;
        }
        for (Direction dir1 : Direction.Plane.HORIZONTAL) {
            TravelersNode diag;
            Direction dir2 = dir1.m_122427_();
            if (!TravelersSwimNodeEvaluator.hasMalus((TravelersNode)neighbors.get(dir1)) || !TravelersSwimNodeEvaluator.hasMalus((TravelersNode)neighbors.get(dir2)) || !this.isNodeValid(diag = this.findAcceptedNode(current.x + dir1.m_122429_() + dir2.m_122429_(), current.y, current.z + dir1.m_122431_() + dir2.m_122431_()))) continue;
            outputArray[i++] = diag;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable TravelersNode node) {
        return node != null && !node.closed;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(int x, int y, int z) {
        TravelersPathType type = this.getCachedBlockType(x, y, z);
        if (!this.allowBreaching && type != TravelersPathType.WATER && type != TravelersPathType.BREACH) {
            return null;
        }
        float malus = this.mob.getPathfindingMalus(type);
        if (malus < 0.0f) {
            return null;
        }
        TravelersNode node = this.getNode(x, y, z);
        node.type = type;
        node.costMalus = Math.max(node.costMalus, malus);
        CollisionGetter level = this.context.level();
        this.temp.m_122178_(x, y, z);
        BlockState state = level.m_8055_((BlockPos)this.temp);
        if (!state.m_60812_((BlockGetter)level, (BlockPos)this.temp).m_83281_()) {
            return null;
        }
        if (level.m_6425_((BlockPos)this.temp).m_76178_()) {
            node.costMalus += 8.0f;
        }
        if (!this.makeSureYFits(x, y, z)) {
            return null;
        }
        if (!this.canMobStandAt(x, y, z)) {
            return null;
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int half = Math.max(1, Mth.m_14167_((float)((float)this.entityHeight / 2.0f)) / 2);
        for (int i = -half; i < half; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        AABB box = this.mob.m_20191_();
        double width = box.m_82362_();
        double height = box.m_82376_();
        double depth = box.m_82385_();
        double cx = (double)x + 0.5;
        double cz = (double)z + 0.5;
        int minX = Mth.m_14107_((double)(cx - width / 2.0));
        int maxX = Mth.m_14165_((double)(cx + width / 2.0));
        int maxY = Mth.m_14165_((double)((double)y + height));
        int minZ = Mth.m_14107_((double)(cz - depth / 2.0));
        int maxZ = Mth.m_14165_((double)(cz + depth / 2.0));
        for (int xi = minX; xi < maxX; ++xi) {
            for (int yi = y; yi < maxY; ++yi) {
                for (int zi = minZ; zi < maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        double height = this.mob.m_20206_();
        int maxY = Mth.m_14165_((double)((double)y + height));
        for (int yi = y; yi < maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER) continue;
            return false;
        }
        return true;
    }

    protected TravelersPathType getCachedBlockType(int x, int y, int z) {
        long key = BlockPos.m_121882_((int)x, (int)y, (int)z);
        TravelersPathType cached = (TravelersPathType)((Object)this.pathTypeCache.get(key));
        if (cached != null) {
            return cached;
        }
        TravelersPathType computed = this.getPathType(this.context, x, y, z);
        this.pathTypeCache.put(key, (Object)computed);
        return computed;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return this.getPathTypeOfMob(context, x, y, z, this.mob);
    }

    @Override
    @NotNull
    public TravelersPathType getPathTypeOfMob(@NotNull TravelersPathfindingContext context, int x, int y, int z, @NotNull SmartAnimalBase mob) {
        this.temp.m_122178_(x, y, z);
        BlockState state = context.getBlockState((BlockPos)this.temp);
        FluidState fluid = state.m_60819_();
        if (fluid.m_76178_() && state.m_60647_((BlockGetter)context.level(), (BlockPos)this.temp, PathComputationType.WATER) && state.m_60795_()) {
            return TravelersPathType.BREACH;
        }
        return state.m_60647_((BlockGetter)context.level(), (BlockPos)this.temp, PathComputationType.WATER) ? TravelersPathType.WATER : TravelersPathType.BREACH;
    }
}

