/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class TravelersNode {
    public int x;
    public int y;
    public int z;
    public int hash;
    int heapIdx = -1;
    public float g;
    public float h;
    public float f;
    public float walkedDistance;
    public float costMalus;
    public boolean closed;
    public TravelersPathType type = TravelersPathType.BLOCKED;
    @Nullable
    public TravelersNode cameFrom;
    private BlockPos cachedPos;
    private Vec3 cachedVec;

    public TravelersNode(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.hash = TravelersNode.createHash(x, y, z);
    }

    public TravelersNode() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.hash = 0;
    }

    public static int createHash(int x, int y, int z) {
        return y & 0xFF | (x & Short.MAX_VALUE) << 8 | (z & Short.MAX_VALUE) << 24 | (x < 0 ? Integer.MIN_VALUE : 0) | (z < 0 ? 32768 : 0);
    }

    public static TravelersNode createFromStream(FriendlyByteBuf buffer) {
        TravelersNode node = new TravelersNode(buffer.readInt(), buffer.readInt(), buffer.readInt());
        TravelersNode.readContents(buffer, node);
        return node;
    }

    protected static void readContents(FriendlyByteBuf buffer, TravelersNode node) {
        node.walkedDistance = buffer.readFloat();
        node.costMalus = buffer.readFloat();
        node.closed = buffer.readBoolean();
        node.type = (TravelersPathType)buffer.m_130066_(TravelersPathType.class);
        node.f = buffer.readFloat();
    }

    public TravelersNode cloneAndMove(int x, int y, int z) {
        TravelersNode node = new TravelersNode(x, y, z);
        node.g = this.g;
        node.h = this.h;
        node.f = this.f;
        node.cameFrom = this.cameFrom;
        node.closed = this.closed;
        node.walkedDistance = this.walkedDistance;
        node.costMalus = this.costMalus;
        node.type = this.type;
        return node;
    }

    public float distanceTo(TravelersNode other) {
        float dx = other.x - this.x;
        float dy = other.y - this.y;
        float dz = other.z - this.z;
        return Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
    }

    public float distanceToXZ(TravelersNode other) {
        float dx = other.x - this.x;
        float dz = other.z - this.z;
        return Mth.m_14116_((float)(dx * dx + dz * dz));
    }

    public float distanceTo(BlockPos pos) {
        float dx = pos.m_123341_() - this.x;
        float dy = pos.m_123342_() - this.y;
        float dz = pos.m_123343_() - this.z;
        return Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
    }

    public float distanceToSqr(TravelersNode other) {
        float dx = other.x - this.x;
        float dy = other.y - this.y;
        float dz = other.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceToSqr(BlockPos pos) {
        float dx = pos.m_123341_() - this.x;
        float dy = pos.m_123342_() - this.y;
        float dz = pos.m_123343_() - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceManhattan(TravelersNode other) {
        return Math.abs(other.x - this.x) + Math.abs(other.y - this.y) + Math.abs(other.z - this.z);
    }

    public float distanceManhattan(BlockPos pos) {
        return Math.abs(pos.m_123341_() - this.x) + Math.abs(pos.m_123342_() - this.y) + Math.abs(pos.m_123343_() - this.z);
    }

    public BlockPos asBlockPos() {
        if (this.cachedPos == null) {
            this.cachedPos = new BlockPos(this.x, this.y, this.z);
        }
        return this.cachedPos;
    }

    public Vec3 asVec3() {
        if (this.cachedVec == null) {
            this.cachedVec = new Vec3((double)this.x, (double)this.y, (double)this.z);
        }
        return this.cachedVec;
    }

    public boolean inOpenSet() {
        return this.heapIdx >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TravelersNode)) {
            return false;
        }
        TravelersNode other = (TravelersNode)o;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.hash == other.hash;
    }

    public void reset() {
        this.heapIdx = -1;
        this.f = 0.0f;
        this.h = 0.0f;
        this.g = 0.0f;
        this.walkedDistance = 0.0f;
        this.costMalus = 0.0f;
        this.closed = false;
        this.type = TravelersPathType.BLOCKED;
        this.cameFrom = null;
        this.cachedPos = null;
        this.cachedVec = null;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "JSNode{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public void writeToStream(FriendlyByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeFloat(this.walkedDistance);
        buffer.writeFloat(this.costMalus);
        buffer.writeBoolean(this.closed);
        buffer.m_130068_((Enum)this.type);
        buffer.writeFloat(this.f);
    }
}

