/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathTypeCache;

public class TravelersPathfindingContext {
    public final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final CollisionGetter level;
    @Nullable
    private final TravelersPathTypeCache cache;
    private final BlockPos mobPosition;

    public TravelersPathfindingContext(CollisionGetter level, Mob mob) {
        TravelersPathTypeCache travelersPathTypeCache;
        this.level = level;
        Level level2 = mob.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            travelersPathTypeCache = TravelersMain.getCache((Level)serverLevel);
        } else {
            travelersPathTypeCache = null;
        }
        this.cache = travelersPathTypeCache;
        this.mobPosition = mob.m_20183_();
    }

    protected static TravelersPathType getPathTypeFromState(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (state.m_60795_()) {
            return TravelersPathType.OPEN;
        }
        if (state.m_204336_(BlockTags.f_13036_) || state.m_60713_(Blocks.f_50196_) || state.m_60713_(Blocks.f_152545_)) {
            return TravelersPathType.TRAPDOOR;
        }
        if (state.m_60713_(Blocks.f_152499_)) {
            return TravelersPathType.POWDER_SNOW;
        }
        if (state.m_60713_(Blocks.f_50128_) || state.m_60713_(Blocks.f_50685_)) {
            return TravelersPathType.DAMAGE_OTHER;
        }
        if (state.m_60713_(Blocks.f_50719_)) {
            return TravelersPathType.STICKY_HONEY;
        }
        if (state.m_60713_(Blocks.f_50262_)) {
            return TravelersPathType.COCOA;
        }
        if (state.m_60713_(Blocks.f_50070_) || state.m_60713_(Blocks.f_152588_)) {
            return TravelersPathType.DAMAGE_CAUTIOUS;
        }
        FluidState fluid = state.m_60819_();
        if (fluid.m_205070_(FluidTags.f_13132_)) {
            return TravelersPathType.LAVA;
        }
        if (TravelersNodeEvaluator.isBurningBlock(state)) {
            return TravelersPathType.DAMAGE_FIRE;
        }
        if (block instanceof DoorBlock) {
            DoorBlock door = (DoorBlock)block;
            return (Boolean)state.m_61143_((Property)DoorBlock.f_52727_) != false ? TravelersPathType.DOOR_OPEN : (door.m_278711_().f_278463_() ? TravelersPathType.DOOR_WOOD_CLOSED : TravelersPathType.DOOR_IRON_CLOSED);
        }
        if (block instanceof BaseRailBlock) {
            BaseRailBlock rail = (BaseRailBlock)block;
            return TravelersPathType.RAIL;
        }
        if (block instanceof LeavesBlock) {
            LeavesBlock rail = (LeavesBlock)block;
            return TravelersPathType.LEAVES;
        }
        if (state.m_204336_(BlockTags.f_13039_) || state.m_204336_(BlockTags.f_13032_) || block instanceof FenceGateBlock && !((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
            return TravelersPathType.FENCE;
        }
        if (!state.m_60647_(level, pos, PathComputationType.LAND)) {
            return TravelersPathType.BLOCKED;
        }
        return fluid.m_205070_(FluidTags.f_13131_) ? TravelersPathType.WATER : TravelersPathType.OPEN;
    }

    public TravelersPathType getPathTypeFromState(int x, int y, int z) {
        BlockPos.MutableBlockPos pos = this.mutablePos.m_122178_(x, y, z);
        return TravelersPathfindingContext.getPathTypeFromState((BlockGetter)this.level, (BlockPos)pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.level.m_8055_(pos);
    }

    public CollisionGetter level() {
        return this.level;
    }

    public BlockPos mobPosition() {
        return this.mobPosition;
    }

    BlockPos currentEvalPos() {
        return this.mutablePos;
    }
}

