/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.vanilla;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.vanilla.TLGoalUtils;
import travelers.server.animal.entity.pathingsystem.vanilla.TLRandomPos;

public class TLAirAndWaterRandomPos {
    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround) {
        boolean flag = TLGoalUtils.mobRestricted(mob, maxDistance);
        return TLRandomPos.generateBestRandomPos(() -> TLAirAndWaterRandomPos.generateRandomPos(mob, maxDistance, yRange, maxDistanceOfGround, flag), arg_0 -> ((SmartAnimalBase)mob).m_21692_(arg_0));
    }

    @Nullable
    private static BlockPos generateRandomPos(SmartAnimalBase mob, int maxDistance, int yRange, int maxDistanceOfGround, boolean shortCircuit) {
        BlockPos pos;
        RandomSource rng = mob.m_217043_();
        int baseX = mob.m_20183_().m_123341_();
        int baseY = mob.m_20183_().m_123342_();
        int baseZ = mob.m_20183_().m_123343_();
        int xRange = Math.max(1, maxDistance * 2 + 1);
        int ySafeRange = Math.max(1, yRange * 2 + 1);
        int x = baseX + rng.m_188503_(xRange) - maxDistance;
        int z = baseZ + rng.m_188503_(xRange) - maxDistance;
        int y = baseY + rng.m_188503_(ySafeRange) - yRange;
        if (y < baseY + 2) {
            y = baseY + 2 + rng.m_188503_(Math.max(1, yRange));
        }
        if (maxDistanceOfGround != -1) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(x, baseY, z);
            while (cursor.m_123342_() > mob.m_9236_().m_141937_() && mob.m_9236_().m_46859_((BlockPos)cursor)) {
                cursor.m_122173_(Direction.DOWN);
            }
            int groundY = cursor.m_123342_();
            int minY = groundY + 1;
            int maxY = groundY + maxDistanceOfGround;
            y = Math.max(minY, Math.min(maxY, y));
        }
        if (TLGoalUtils.isOutsideLimits(pos = new BlockPos(x, y, z), mob) || TLGoalUtils.isRestricted(shortCircuit, mob, pos)) {
            return null;
        }
        return TLGoalUtils.hasMalus(mob, pos) ? null : pos;
    }
}

