/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.vanilla;

import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TLRandomPos {
    private static final int RANDOM_POS_ATTEMPTS = 10;
    private static final Random rng = new Random();

    public static BlockPos generateRandomDirection(int horizontalDistance, int verticalDistance) {
        int dx = rng.nextInt(2 * horizontalDistance + 1) - horizontalDistance;
        int dy = rng.nextInt(2 * verticalDistance + 1) - verticalDistance;
        int dz = rng.nextInt(2 * horizontalDistance + 1) - horizontalDistance;
        return new BlockPos(dx, dy, dz);
    }

    @Nullable
    public static BlockPos generateRandomDirectionWithinRadians(int maxHorizontalDifference, int yRange, int baseY, double baseX, double baseZ, double maxAngleDelta) {
        double baseAngle = Mth.m_14136_((double)baseZ, (double)baseX) - 1.5707963267948966;
        double angle = baseAngle + (2.0 * (double)rng.nextFloat() - 1.0) * maxAngleDelta;
        double distance = Math.sqrt(rng.nextDouble()) * (double)Mth.f_13994_ * (double)maxHorizontalDifference;
        double offsetX = -distance * Math.sin(angle);
        double offsetZ = distance * Math.cos(angle);
        if (Math.abs(offsetX) > (double)maxHorizontalDifference || Math.abs(offsetZ) > (double)maxHorizontalDifference) {
            return null;
        }
        int y = baseY + rng.nextInt(2 * yRange + 1) - yRange;
        return BlockPos.m_274561_((double)offsetX, (double)y, (double)offsetZ);
    }

    public static BlockPos moveUpOutOfSolid(BlockPos pos, int maxY, Predicate<BlockPos> isSolid) {
        if (!isSolid.test(pos)) {
            return pos;
        }
        BlockPos current = pos.m_7494_();
        while (current.m_123342_() < maxY && isSolid.test(current)) {
            current = current.m_7494_();
        }
        return current;
    }

    public static BlockPos moveUpToAboveSolid(BlockPos pos, int aboveSolidAmount, int maxY, Predicate<BlockPos> isSolid) {
        BlockPos next;
        if (aboveSolidAmount < 0) {
            throw new IllegalArgumentException("aboveSolidAmount must be >= 0, got: " + aboveSolidAmount);
        }
        if (!isSolid.test(pos)) {
            return pos;
        }
        BlockPos base = pos.m_7494_();
        while (base.m_123342_() < maxY && isSolid.test(base)) {
            base = base.m_7494_();
        }
        BlockPos check = base;
        for (int i = 0; i < aboveSolidAmount && check.m_123342_() < maxY && !isSolid.test(next = check.m_7494_()); ++i) {
            check = next;
        }
        return check;
    }

    @Nullable
    public static Vec3 generateBestRandomPos(Supplier<BlockPos> supplier, ToDoubleFunction<BlockPos> scorer) {
        double bestScore = Double.NEGATIVE_INFINITY;
        BlockPos bestPos = null;
        for (int i = 0; i < 10; ++i) {
            double score;
            BlockPos pos = supplier.get();
            if (pos == null || !((score = scorer.applyAsDouble(pos)) > bestScore)) continue;
            bestScore = score;
            bestPos = pos;
        }
        return bestPos != null ? Vec3.m_82539_(bestPos) : null;
    }

    public static BlockPos generateRandomPosTowardDirection(PathfinderMob mob, int range, BlockPos offset) {
        int dx = offset.m_123341_();
        int dz = offset.m_123343_();
        if (mob.m_21536_() && range > 1) {
            BlockPos center = mob.m_21534_();
            dx += mob.m_20185_() > (double)center.m_123341_() ? -rng.nextInt(range / 2) : rng.nextInt(range / 2);
            dz += mob.m_20189_() > (double)center.m_123343_() ? -rng.nextInt(range / 2) : rng.nextInt(range / 2);
        }
        return BlockPos.m_274561_((double)(mob.m_20185_() + (double)dx), (double)(mob.m_20186_() + (double)offset.m_123342_()), (double)(mob.m_20189_() + (double)dz));
    }

    @Nullable
    public static Vec3 findTargetPos(PathfinderMob mob, int xRange, int yRange, int yVariation) {
        BlockPos origin = mob.m_20183_();
        return TLRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = TLRandomPos.generateRandomDirection(xRange, yVariation);
            return origin.m_121955_((Vec3i)offset);
        }, pos -> mob.m_21692_(pos));
    }
}

