/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.task;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.level.Level;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;

public abstract class TravelerTaskBase {
    protected final Random random;
    protected final SmartAnimalBase animal;
    protected final Level level;
    private final Set<TaskGoal> goals = new HashSet<TaskGoal>();
    protected int checkCooldown;
    private boolean isRunning;
    private boolean shouldStop;
    private TaskPriority priority = TaskPriority.LOW;

    public TravelerTaskBase(SmartAnimalBase baseAnimal) {
        this.animal = baseAnimal;
        this.level = this.animal.m_9236_();
        this.random = new Random();
    }

    public TaskPriority getPriority() {
        return this.priority;
    }

    public abstract void onStart();

    public abstract void tick();

    public abstract void onStop();

    public final void run() {
        this.isRunning = true;
    }

    public final void stop() {
        this.shouldStop = true;
    }

    public boolean canInterrupt() {
        return false;
    }

    public boolean requiresUpdateEveryTick() {
        return false;
    }

    public final void actuallyStop() {
        this.onStop();
        this.cleanUp();
        this.isRunning = false;
        this.shouldStop = false;
    }

    public void cleanUp() {
    }

    public boolean shouldRun() {
        return false;
    }

    public boolean canContinueRunning() {
        return this.shouldRun();
    }

    public Set<TaskGoal> getGoals() {
        return this.goals;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isShouldStop() {
        return this.shouldStop;
    }

    public void setPriority(TaskPriority priority) {
        this.priority = priority;
    }
}

