/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.obj;

import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersMoveAnalysis {
    private final SmartAnimalBase animal;
    private double lastX;
    private double lastZ;
    private final double[] speedHistory;
    private int index = 0;
    private int count = 0;
    private static final double MOVE_THRESHOLD = 0.02;
    private static final double NOISE_EPSILON = 0.01;
    private static final int STABLE_TICKS = 5;
    private final int smoothing;
    private boolean isMoving = false;
    private int stableCounter = 0;

    public TravelersMoveAnalysis(SmartAnimalBase smartAnimalBase, int smoothingTicks) {
        this.animal = smartAnimalBase;
        this.lastX = this.animal.m_20185_();
        this.lastZ = this.animal.m_20189_();
        this.smoothing = Math.max(1, smoothingTicks);
        this.speedHistory = new double[this.smoothing];
    }

    public void update() {
        boolean movingNow;
        double speed;
        double x = this.animal.m_20185_();
        double z = this.animal.m_20189_();
        double dx = x - this.lastX;
        double dz = z - this.lastZ;
        if (Math.abs(dx) < 0.01) {
            dx = 0.0;
        }
        if (Math.abs(dz) < 0.01) {
            dz = 0.0;
        }
        this.speedHistory[this.index] = speed = Math.sqrt(dx * dx + dz * dz);
        this.index = (this.index + 1) % this.smoothing;
        if (this.count < this.smoothing) {
            ++this.count;
        }
        this.lastX = x;
        this.lastZ = z;
        double avgSpeed = this.getAverageSpeed();
        boolean bl = movingNow = avgSpeed > 0.02;
        if (movingNow != this.isMoving) {
            ++this.stableCounter;
            if (this.stableCounter >= 5) {
                this.isMoving = movingNow;
                this.stableCounter = 0;
            }
        } else {
            this.stableCounter = 0;
        }
    }

    private double getAverageSpeed() {
        double sum = 0.0;
        for (int i = 0; i < this.count; ++i) {
            sum += this.speedHistory[i];
        }
        return sum / (double)this.count;
    }

    public SmartAnimalBase getAnimal() {
        return this.animal;
    }

    public double getLastX() {
        return this.lastX;
    }

    public double getLastZ() {
        return this.lastZ;
    }

    public double[] getSpeedHistory() {
        return this.speedHistory;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.count;
    }

    public int getSmoothing() {
        return this.smoothing;
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public int getStableCounter() {
        return this.stableCounter;
    }
}

