/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.packet.obj;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.joml.Vector3f;
import travelers.TravelersMain;
import travelers.client.misc.CameraShakeHandler;
import travelers.server.packet.TravelersPacketsHandler;
import travelers.server.packet.obj.TravelersBasePacket;

public final class TravelersShakeCamera
extends TravelersBasePacket<TravelersShakeCamera> {
    public static final TravelersPacketsHandler<TravelersShakeCamera> handler = TravelersShakeCamera.handler();
    private final boolean groundCheck;
    private final float strength;
    private final int length;
    private final float shakeDistance;
    private final Vector3f vector3f;
    public static final ResourceLocation ID = TravelersMain.createId("shakecamera");

    public TravelersShakeCamera(boolean groundCheck, float strength, int length, float shakeDistance, Vector3f vector3f) {
        this.groundCheck = groundCheck;
        this.strength = strength;
        this.length = length;
        this.shakeDistance = shakeDistance;
        this.vector3f = vector3f;
    }

    public TravelersShakeCamera(FriendlyByteBuf buf) {
        this.groundCheck = buf.readBoolean();
        this.strength = buf.readFloat();
        this.length = buf.readInt();
        this.shakeDistance = buf.readFloat();
        float x = buf.readFloat();
        float y = buf.readFloat();
        float z = buf.readFloat();
        this.vector3f = new Vector3f(x, y, z);
    }

    public TravelersShakeCamera() {
        this.groundCheck = false;
        this.strength = 0.0f;
        this.length = 0;
        this.shakeDistance = 0.0f;
        this.vector3f = new Vector3f();
    }

    public boolean groundCheck() {
        return this.groundCheck;
    }

    public float strength() {
        return this.strength;
    }

    public int length() {
        return this.length;
    }

    public float shakeDistance() {
        return this.shakeDistance;
    }

    public Vector3f vector3f() {
        return this.vector3f;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.groundCheck);
        buf.writeFloat(this.strength);
        buf.writeInt(this.length);
        buf.writeFloat(this.shakeDistance);
        buf.writeFloat(this.vector3f.x());
        buf.writeFloat(this.vector3f.y());
        buf.writeFloat(this.vector3f.z());
    }

    @Override
    public TravelersShakeCamera decode(FriendlyByteBuf buf) {
        return new TravelersShakeCamera(buf);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    private static TravelersPacketsHandler<TravelersShakeCamera> handler() {
        return new TravelersPacketsHandler<TravelersShakeCamera>(){

            @Override
            public void handleClient(TravelersShakeCamera packet) {
                CameraShakeHandler.startShake(packet.groundCheck(), packet.strength(), packet.shakeDistance(), packet.length(), packet.vector3f());
            }

            @Override
            public void handleServer(TravelersShakeCamera packet, ServerPlayer sender) {
            }
        };
    }
}

