/*
 * Decompiled with CFR 0.152.
 */
package travelers.util;

import java.util.ArrayList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.util.TravelersAzure;
import travelers.util.helper.PlatformHelper;

public class TravelersUtil {
    private static final ArrayList<String> disabledModIds = new ArrayList();

    public static void disableModForGecko(String modId) {
        disabledModIds.add(modId);
        if (PlatformHelper.properties.isModLoaded("geckolib")) {
            try {
                PlatformHelper.properties.disableGecko(modId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean noBlockCollisions(SmartAnimalBase mob, AABB aabb) {
        Level level = mob.m_9236_();
        for (VoxelShape blockCollision : level.m_186434_((Entity)mob, aabb)) {
            if (!blockCollision.m_83281_()) continue;
            return false;
        }
        return true;
    }

    public static boolean closerThan(Vec3 from, Vec3 to, double horizontalDistance, double verticalDistance) {
        double d0 = from.m_7096_() - to.m_7096_();
        double d1 = from.m_7098_() - to.m_7098_();
        double d2 = from.m_7094_() - to.m_7094_();
        return Mth.m_211589_((double)d0, (double)d2) < Mth.m_144952_((double)horizontalDistance) && Math.abs(d1) < verticalDistance;
    }

    public static void disableModForAzure(String modId) {
        if (PlatformHelper.properties.isModLoaded("azurelib")) {
            TravelersAzure.disableMod(modId);
        }
    }

    public static ArrayList<String> getDisabledModIds() {
        return disabledModIds;
    }
}

