/*
 * Decompiled with CFR 0.152.
 */
package travelers.util.helper;

import com.google.common.base.Supplier;
import java.util.HashMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import travelers.util.helper.PlatformHelper;

public class TravelersRegistry<T> {
    private final Registry<T> registry;
    private final String modId;
    private boolean storeValues = false;
    private HashMap<String, Supplier<T>> values;

    public TravelersRegistry(Registry<T> registry, String modId) {
        this.registry = registry;
        this.modId = modId;
    }

    public TravelersRegistry<T> storeValues() {
        this.storeValues = true;
        this.values = new HashMap();
        return this;
    }

    public Supplier<T> register(String name, Supplier<T> supplier) {
        Supplier<T> tSupplier = PlatformHelper.register(this.registry, new ResourceLocation(this.modId, name), supplier);
        if (this.storeValues) {
            this.values.put(name, tSupplier);
        }
        return tSupplier;
    }

    public HashMap<String, Supplier<T>> getValues() {
        return this.values;
    }
}

