/*
 * Decompiled with CFR 0.152.
 */
package travelers.world;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.registries.ForgeRegistries;
import travelers.server.world.TravelersBiomeModificator;
import travelers.server.world.obj.BiomeHolder;
import travelers.server.world.obj.TravelersFeatureModification;
import travelers.server.world.obj.TravelersSpawnModification;

public class NeoTravelersBiomeModificator
extends TravelersBiomeModificator {
    protected static final HashMap<String, ArrayList<TravelersSpawnModification>> SPAWN_MODIFICATIONS = new HashMap();
    protected static final HashMap<String, ArrayList<TravelersFeatureModification>> FEATURE_MODIFICATIONS = new HashMap();

    @Override
    public void addSpawn(String modid, String spawnName, BiomeHolder targetBiomes, MobCategory mobCategory, Supplier<EntityType<? extends Entity>> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (DatagenModLoader.isRunningDataGen()) {
            SPAWN_MODIFICATIONS.putIfAbsent(modid, new ArrayList());
            SPAWN_MODIFICATIONS.get(modid).add(new TravelersSpawnModification(targetBiomes, spawnName, mobCategory, entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    @Override
    public void addFeature(String modid, String featureName, BiomeHolder targetBiomes, ResourceKey<PlacedFeature> placedFeature, GenerationStep.Decoration generationStep) {
        if (DatagenModLoader.isRunningDataGen()) {
            FEATURE_MODIFICATIONS.putIfAbsent(modid, new ArrayList());
            FEATURE_MODIFICATIONS.get(modid).add(new TravelersFeatureModification(targetBiomes, featureName, placedFeature, generationStep));
        }
    }

    public static void bootstrap(String modId, BootstapContext<BiomeModifier> context) {
        ArrayList<TravelersFeatureModification> featureList;
        HolderGetter features = context.m_255420_(Registries.f_256988_);
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        ArrayList<TravelersSpawnModification> spawnList = SPAWN_MODIFICATIONS.get(modId);
        if (spawnList != null) {
            for (TravelersSpawnModification modification : spawnList) {
                HolderSet biomeTags = NeoTravelersBiomeModificator.getTags((HolderGetter<Biome>)biomes, modification.targetBiomes());
                context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation(modId, modification.name())), (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(biomeTags, Collections.singletonList(new MobSpawnSettings.SpawnerData((EntityType)modification.entityType().get(), modification.weight(), modification.minGroupSize(), modification.maxGroupSize()))));
            }
            SPAWN_MODIFICATIONS.remove(modId);
        }
        if ((featureList = FEATURE_MODIFICATIONS.get(modId)) != null) {
            for (TravelersFeatureModification modification : featureList) {
                HolderSet biomeTags = NeoTravelersBiomeModificator.getTags((HolderGetter<Biome>)biomes, modification.targetBiomes());
                context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation(modId, modification.name())), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(biomeTags, (HolderSet)Holder.m_205709_((Object)features.m_255043_(modification.placedFeature())), modification.generationStep()));
            }
            FEATURE_MODIFICATIONS.remove(modId);
        }
    }

    private static HolderSet getTags(HolderGetter<Biome> biomes, BiomeHolder biomeHolder) {
        HolderSet.Named biomeTags;
        if (biomeHolder.getBiomeTag() != null) {
            biomeTags = biomes.m_254956_(biomeHolder.getBiomeTag());
        } else {
            ArrayList<Holder.Reference> holders = new ArrayList<Holder.Reference>();
            for (ResourceKey<Biome> biomeTag : biomeHolder.getBiomeTags()) {
                holders.add(biomes.m_255043_(biomeTag));
            }
            biomeTags = HolderSet.m_205800_(holders);
        }
        return biomeTags;
    }
}

