/*
 * Decompiled with CFR 0.152.
 */
package travelers.world;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import travelers.server.world.obj.BiomeHolder;
import travelers.server.world.obj.TravelersFeatureModification;
import travelers.server.world.obj.TravelersSpawnModification;
import travelers.world.NeoTravelersBiomeModificator;

public class TravelersBiomeModifierProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;

    public TravelersBiomeModifierProvider(PackOutput output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList<TravelersFeatureModification> featureList;
        ArrayList futures = new ArrayList();
        ArrayList<TravelersSpawnModification> spawnList = NeoTravelersBiomeModificator.SPAWN_MODIFICATIONS.get(this.modId);
        if (spawnList != null) {
            for (TravelersSpawnModification modification : spawnList) {
                futures.add(this.writeSpawnModifier(cache, modification));
            }
            NeoTravelersBiomeModificator.SPAWN_MODIFICATIONS.remove(this.modId);
        }
        if ((featureList = NeoTravelersBiomeModificator.FEATURE_MODIFICATIONS.get(this.modId)) != null) {
            for (TravelersFeatureModification modification : featureList) {
                futures.add(this.writeFeatureModifier(cache, modification));
            }
            NeoTravelersBiomeModificator.FEATURE_MODIFICATIONS.remove(this.modId);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<?> writeSpawnModifier(CachedOutput cache, TravelersSpawnModification mod) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "forge:add_spawns");
        json.add("biomes", this.buildBiomeList(mod.targetBiomes()));
        JsonArray spawners = new JsonArray();
        JsonObject spawn = new JsonObject();
        spawn.addProperty("type", ((EntityType)mod.entityType().get()).toString());
        spawn.addProperty("weight", (Number)mod.weight());
        spawn.addProperty("minCount", (Number)mod.minGroupSize());
        spawn.addProperty("maxCount", (Number)mod.maxGroupSize());
        spawners.add((JsonElement)spawn);
        json.add("spawners", (JsonElement)spawners);
        Path path = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId + "/forge/biome_modifier/" + mod.name() + ".json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    private CompletableFuture<?> writeFeatureModifier(CachedOutput cache, TravelersFeatureModification mod) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "forge:add_features");
        json.add("biomes", this.buildBiomeList(mod.targetBiomes()));
        JsonArray features = new JsonArray();
        features.add(mod.placedFeature().m_135782_().toString());
        json.add("features", (JsonElement)features);
        json.addProperty("step", mod.generationStep().m_224194_());
        Path path = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId + "/forge/biome_modifier/" + mod.name() + ".json");
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    private JsonElement buildBiomeList(BiomeHolder holder) {
        if (holder.getBiomeTag() != null) {
            ResourceLocation id = holder.getBiomeTag().f_203868_();
            return new JsonPrimitive("#" + String.valueOf(id));
        }
        JsonArray arr = new JsonArray();
        for (ResourceKey<Biome> key : holder.getBiomeTags()) {
            arr.add("#" + String.valueOf(key.m_135782_()));
        }
        return arr;
    }

    public String m_6055_() {
        return "Biome Modifier Provider: " + this.modId;
    }
}

