/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.dispatch.command.action.codec;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.animation.dispatch.command.action.registry.AzActionRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class AzActionCodec {
    @NotNull
    public AzAction decode(@NotNull class_2540 byteBuf) {
        short id = byteBuf.readShort();
        Function<class_2540, AzAction> codec = AzActionRegistry.getDecoderOrNull(id);
        if (codec == null) {
            throw new NullPointerException("Could not find action decoder for a given action ID while decoding data. ID: " + id);
        }
        return codec.apply(byteBuf);
    }

    public void encode(@NotNull class_2540 byteBuf, @NotNull AzAction action) {
        class_2960 resourceLocation = action.getResourceLocation();
        Short id = AzActionRegistry.getIdOrNull(resourceLocation);
        BiConsumer<class_2540, AzAction> encoder = AzActionRegistry.getEncoderOrNull(resourceLocation);
        if (id == null) {
            throw new NullPointerException("Could not find action ID for a given resource location while encoding data. Resource Location: " + String.valueOf(resourceLocation));
        }
        byteBuf.writeShort((int)id.shortValue());
        if (encoder == null) {
            throw new NullPointerException("Could not find action encoder for a given resource location while encoding data. Resource Location: " + String.valueOf(resourceLocation) + ", ID: " + id);
        }
        encoder.accept(byteBuf, action);
    }
}

