/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.block;

import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.block.AzBlockEntityRenderer;
import mod.azure.azurelib.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.render.block.AzBlockEntityRendererPipelineContext;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzBlockEntityRendererPipeline<T extends class_2586>
extends AzRendererPipeline<Long, T> {
    private final AzBlockEntityRenderer<T> blockEntityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzBlockEntityRendererPipeline(AzBlockEntityRendererConfig<T> config, AzBlockEntityRenderer<T> blockEntityRenderer) {
        super(config);
        this.blockEntityRenderer = blockEntityRenderer;
    }

    protected AzBlockEntityRendererPipelineContext<T> createContext(AzRendererPipeline<Long, T> rendererPipeline) {
        return (AzBlockEntityRendererPipelineContext)this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<Long, T> createModelRenderer(AzLayerRenderer<Long, T> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<Long, T> createLayerRenderer(AzRendererConfig<Long, T> config) {
        return new AzLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        this.entityRenderTranslations.set((Matrix4fc)poseStack.method_23760().method_23761());
        float scaleWidth = this.config.scaleWidth((class_2586)context.animatable());
        float scaleHeight = this.config.scaleHeight((class_2586)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (this.config.alpha((class_2586)context.animatable()) < 1.0f) {
            context.setAlpha(this.config.alpha((class_2586)context.animatable()));
        }
        this.config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<Long, T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    public AzBlockEntityRenderer<T> getRenderer() {
        return this.blockEntityRenderer;
    }
}

