/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSBoatModel;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSChestBoatModel;
import jp.jurassicsaga.server.base.entity.obj.vanilla.JSBoatEntity;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class JSBoatRenderer
extends EntityRenderer<JSBoatEntity> {
    private final Map<JSBoatEntity.CustomType, Pair<ResourceLocation, ListModel<JSBoatEntity>>> boatResources;

    public JSBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(JSBoatEntity.CustomType.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, modType -> Pair.of((Object)new ResourceLocation("jurassicsaga", JSBoatRenderer.getTextureLocation(modType, pChestBoat)), this.createBoatModel(pContext, (JSBoatEntity.CustomType)((Object)modType), pChestBoat))));
    }

    private ListModel<JSBoatEntity> createBoatModel(EntityRendererProvider.Context pContext, JSBoatEntity.CustomType pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? JSBoatRenderer.createChestBoatModelName(pType) : JSBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new JSChestBoatModel(modelpart) : new JSBoatModel(modelpart);
    }

    public static ModelLayerLocation createChestBoatModelName(JSBoatEntity.CustomType pType) {
        return JSBoatRenderer.createLocation("boat/chest" + pType.getName());
    }

    public static ModelLayerLocation createBoatModelName(JSBoatEntity.CustomType pType) {
        return JSBoatRenderer.createLocation("boat/" + pType.getName());
    }

    private static ModelLayerLocation createLocation(String pPath) {
        return new ModelLayerLocation(new ResourceLocation("jurassicsaga", pPath), "main");
    }

    private static String getTextureLocation(JSBoatEntity.CustomType pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/boat/chest/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    public void render(JSBoatEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.m_85836_();
        pMatrixStack.m_252880_(0.0f, 0.375f, 0.0f);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        float f = (float)pEntity.m_38385_() - pPartialTicks;
        float f1 = pEntity.m_38384_() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)pEntity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = pEntity.m_38352_(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.m_252781_(new Quaternionf().setAngleAxis(pEntity.m_38352_(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<JSBoatEntity>> pair = this.getModelWithLocation(pEntity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ListModel listmodel = (ListModel)pair.getSecond();
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        listmodel.m_6973_((Entity)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(listmodel.m_103119_(resourcelocation));
        listmodel.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.m_5842_()) {
            VertexConsumer vertexconsumer1 = pBuffer.m_6299_(RenderType.m_110478_());
            if (listmodel instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)listmodel;
                waterpatchmodel.m_102282_().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
            }
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull JSBoatEntity pEntity) {
        return (ResourceLocation)this.getModelWithLocation(pEntity).getFirst();
    }

    public Pair<ResourceLocation, ListModel<JSBoatEntity>> getModelWithLocation(JSBoatEntity boat) {
        return this.boatResources.get((Object)boat.getNWBoatEntityType());
    }
}

