/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.renderer.entity.vehicle;

import java.util.Optional;
import jp.jurassicsaga.server.base.entity.obj.other.vehicle.JSVehicleEntity;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.animation.AzAnimatorConfig;
import mod.azure.azurelib.animation.controller.AzAnimationController;
import mod.azure.azurelib.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.render.entity.AzEntityRenderer;
import mod.azure.azurelib.render.entity.AzEntityRendererConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VehicleRenderer<T extends JSVehicleEntity>
extends AzEntityRenderer<T> {
    protected String vehicleName;

    public VehicleRenderer(EntityRendererProvider.Context renderManager, String vehicleName) {
        super(AzEntityRendererConfig.builder((ResourceLocation)new ResourceLocation("jurassicsaga", "geo/vehicle/" + vehicleName + ".geo.json"), (ResourceLocation)new ResourceLocation("jurassicsaga", "textures/entity/vehicle/" + vehicleName + ".png")).setAlpha(1.0f).setRenderType(a -> RenderType.m_110473_((ResourceLocation)new ResourceLocation("jurassicsaga", "textures/entity/vehicle/" + vehicleName + ".png"))).setAnimatorProvider(() -> new Animator(vehicleName)).build(), renderManager);
        this.vehicleName = vehicleName;
    }

    public VehicleRenderer(AzEntityRendererConfig<T> config, EntityRendererProvider.Context context) {
        super(config, context);
    }

    public static class Animator<T extends JSVehicleEntity>
    extends AzEntityAnimator<T> {
        private final ResourceLocation loc;

        public Animator(String vehicleName) {
            super(AzAnimatorConfig.builder().build());
            this.loc = new ResourceLocation("jurassicsaga", "animations/vehicle/" + vehicleName + ".animation.json");
        }

        public void registerControllers(AzAnimationControllerContainer<T> azAnimationControllerContainer) {
            azAnimationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"base_controller").build(), new AzAnimationController[0]);
        }

        public void setCustomAnimations(JSVehicleEntity animatable, float partialTicks) {
            double forwardZ;
            AzBakedModel bakedModel = this.context().boneCache().getBakedModel();
            float fps = Math.max(1, Minecraft.m_91087_().m_260875_());
            float dt = 30.0f / fps;
            float t = 1.0f - (float)Math.exp(-dt);
            t *= 1.0f + partialTicks * 0.5f;
            double dx = animatable.m_20185_() - animatable.f_19854_;
            double dz = animatable.m_20189_() - animatable.f_19856_;
            float yawRad = animatable.m_146908_() * ((float)Math.PI / 180);
            double forwardX = -Math.sin(yawRad);
            double forwardMovement = dx * forwardX + dz * (forwardZ = Math.cos(yawRad));
            if (Math.abs(forwardMovement) > 1.0E-5) {
                float deltaRotation = (float)(forwardMovement * (double)t);
                animatable.rearWheelRot -= deltaRotation;
                animatable.frontLeftWheelRot -= deltaRotation;
                animatable.frontRightWheelRot -= deltaRotation;
            }
            Optional rearAxle = bakedModel.getBone("rodRear");
            rearAxle.ifPresent(azBone -> azBone.setRotX(animatable.rearWheelRot));
            Optional fl = bakedModel.getBone("wheelFrontLeft");
            fl.ifPresent(azBone -> azBone.setRotX(animatable.frontLeftWheelRot));
            Optional fr = bakedModel.getBone("wheelFrontRight");
            fr.ifPresent(azBone -> azBone.setRotX(animatable.frontRightWheelRot));
        }

        @NotNull
        public ResourceLocation getAnimationLocation(JSVehicleEntity block) {
            return this.loc;
        }
    }
}

