/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.EntityInspectPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.JournalPage;
import jp.jurassicsaga.client.base.screen.obj.widget.GuidebookTab;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuidebookScreen
extends Screen {
    protected final JSTheme theme;
    private final int entityId;
    private String pageName = "journal";
    private static final String BASE_BG = "textures/gui/guidebook/background";
    private static final int WIDTH = 347;
    private static final int HEIGHT = 246;
    private static final Map<String, GuidebookPage> PAGES = new HashMap<String, GuidebookPage>();
    private final List<AbstractWidget> buttons = new ArrayList<AbstractWidget>();

    public GuidebookScreen(int id) {
        super((Component)Component.m_237115_((String)"js.screen.empty"));
        this.theme = JSCommon.config.theme;
        this.entityId = id;
        if (id != -1) {
            this.pageName = "entityInspect";
        }
        PAGES.put("entityInspect", new EntityInspectPage(this));
        PAGES.put("journal", new JournalPage(this));
        PAGES.put("help", new JournalPage(this));
    }

    private static ResourceLocation tex(boolean jp) {
        return new ResourceLocation("jurassicsaga", BASE_BG + (jp ? "_jp" : "") + ".png");
    }

    public void m_7856_() {
        super.m_7856_();
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        this.buttons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.buttons.clear();
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.init();
        }
        if (this.pageName.equals("entityInspect")) {
            this.addButton((AbstractWidget)new GuidebookTab(false, cx - 208, cy + 97, 25, 12, (Component)Component.m_237119_(), press -> {
                this.pageName = "journal";
                this.m_7856_();
            }, JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_left_hover" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png"), JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_left" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png")));
        } else {
            if (this.entityId != -1) {
                this.addButton((AbstractWidget)new GuidebookTab(false, cx - 208, cy - 103, 25, 12, (Component)Component.m_237119_(), press -> {
                    this.pageName = "entityInspect";
                    this.m_7856_();
                }, JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_right_hover" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png"), JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_right" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png")));
            }
            this.addButton((AbstractWidget)new GuidebookTab(false, cx - 205, cy + 94, 18, 18, (Component)Component.m_237119_(), press -> {
                this.pageName = "help";
                this.m_7856_();
            }, JSCommon.createId("textures/gui/sprites/container/guidebook/search" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png"), JSCommon.createId("textures/gui/sprites/container/guidebook/search" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png")));
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        boolean jp = this.theme == JSTheme.JP;
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        g.m_280163_(GuidebookScreen.tex(jp), cx - 173, cy - 123, 0.0f, 0.0f, 347, 246, 347, 246);
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.render(cx, cy, g, mouseX, mouseY, partialTick);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.tick();
        }
    }

    public void setPage(String name) {
        this.pageName = name;
        this.m_7856_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.mouseScrolled(mouseX, mouseY, delta);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int key, int scan, int mod) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.keyPressed(key, scan, mod);
        }
        return super.m_7933_(key, scan, mod);
    }

    public boolean m_7920_(int key, int scan, int mod) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.keyReleased(key, scan, mod);
        }
        return super.m_7920_(key, scan, mod);
    }

    public boolean m_5534_(char code, int mod) {
        GuidebookPage page = PAGES.get(this.pageName);
        if (page != null) {
            page.charTyped(code, mod);
        }
        return super.m_5534_(code, mod);
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void addButton(AbstractWidget button) {
        this.m_142416_((GuiEventListener)button);
        this.buttons.add(button);
    }

    public JSTheme getTheme() {
        return this.theme;
    }

    public int getEntityId() {
        return this.entityId;
    }
}

