/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook.obj;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookScreen;
import jp.jurassicsaga.client.base.screen.obj.guidebook.obj.JournalSubPage;
import jp.jurassicsaga.client.base.screen.obj.widget.NoClickHoverClickButton;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diet;
import jp.jurassicsaga.server.base.animal.entity.obj.diet.Diets;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

public class JournalPage
extends GuidebookPage {
    private JournalSubPage currentSubPage;
    private final ArrayList<JSAnimal<?>> animals = JSAnimals.getAnimals();
    private int currentPageId = 0;
    private List<ItemStack> stacks = null;
    private int scrollOffset = 0;
    private int scrollTicker = 0;

    public JournalPage(GuidebookScreen holder) {
        super(holder);
    }

    @Override
    public void init() {
        int i = this.holder.f_96543_ / 2;
        int j = this.holder.f_96544_ / 2;
        this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 + 148, j - 8 + 105, 25, 12, (Component)Component.m_237119_(), press -> {
            int size;
            if (this.currentSubPage != null) {
                this.currentSubPage = null;
            }
            this.currentPageId = (size = this.animals.stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()).toList().size()) < this.currentPageId + 1 ? 0 : ++this.currentPageId;
            this.holder.m_7856_();
        }, JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_right_hover" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png"), JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_right" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png")));
        this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 157, j - 8 + 105, 25, 12, (Component)Component.m_237119_(), press -> {
            if (this.currentSubPage != null) {
                this.currentSubPage = null;
            }
            int size = this.animals.stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()).toList().size();
            this.currentPageId = this.currentPageId - 1 < 0 ? size - 1 : --this.currentPageId;
            this.holder.m_7856_();
        }, JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_left_hover" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png"), JSCommon.createId("textures/gui/sprites/container/guidebook/arrow_left" + (this.theme == JSTheme.JP ? "_jp" : "") + ".png")));
        if (this.currentSubPage != null) {
            this.currentSubPage.init();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.currentPageId != 0 && this.stacks != null) {
            this.tickHorizontalScrolling();
        }
    }

    private void tickHorizontalScrolling() {
        int cols = 8;
        int rows = 3;
        int visibleCount = cols * rows;
        int maxOffset = Math.max(0, this.stacks.size() - visibleCount);
        ++this.scrollTicker;
        if (this.scrollTicker > 20) {
            this.scrollTicker = 0;
            ++this.scrollOffset;
            if (this.scrollOffset > maxOffset) {
                this.scrollOffset = 0;
            }
        }
    }

    @Override
    public void render(int i, int j, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.currentPageId == 0) {
            Font font = this.holder.getFont();
            guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)"guidebook.jurassicsaga.page_home"), i - 153, j - 102, 6980223);
            guiGraphics.m_280554_(font, (FormattedText)Component.m_237115_((String)"guidebook.jurassicsaga.home"), i - 155, j - 80, 142, 6980223);
        } else {
            if (this.currentSubPage == null) {
                if (this.currentPageId > this.animals.size()) {
                    this.currentPageId = 0;
                } else if (this.currentPageId < 0) {
                    this.currentPageId = 0;
                }
                JSAnimal animal = this.animals.stream().filter(jsAnimal -> jsAnimal.getAnimalAttributes().getMiscProperties().isShowInGuidebook()).toList().get(this.currentPageId - 1);
                this.currentSubPage = new JournalSubPage(this.holder, animal);
                Supplier<Diet> dietSupplier = animal.getAnimalAttributes().getMetabolismProperties().getDietSupplier();
                if (dietSupplier != Diets.EMPTY) {
                    Diet diet = dietSupplier.get();
                    this.stacks = diet.getAllItems().stream().sorted(Comparator.comparing(item -> item.m_41720_().m_7626_(item).getString())).toList();
                } else {
                    this.stacks = null;
                }
                this.init();
            }
            this.currentSubPage.render(i, j, guiGraphics, mouseX, mouseY, partialTick);
            if (this.stacks != null) {
                guiGraphics.m_280430_(this.holder.getFont(), (Component)Component.m_237115_((String)"guidebook.jurassicsaga.edible_items"), i + 21, j + 35, 6980223);
                this.renderWrappedItems(guiGraphics, i + 20, j + 45, mouseX, mouseY);
            }
        }
    }

    private void renderWrappedItems(GuiGraphics guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        int itemSize = 16;
        int cols = 8;
        int rows = 3;
        int visibleCount = cols * rows;
        int maxOffset = Math.max(0, this.stacks.size() - visibleCount);
        if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int index = this.scrollOffset + col + row * cols;
                if (index >= this.stacks.size()) {
                    return;
                }
                int x = startX + col * itemSize;
                int y = startY + row * itemSize;
                ItemStack stack = this.stacks.get(index);
                guiGraphics.m_280480_(stack, x, y);
                guiGraphics.m_280370_(this.holder.getFont(), stack, x, y);
                if (mouseX < x || mouseX >= x + itemSize || mouseY < y || mouseY >= y + itemSize) continue;
                guiGraphics.m_280153_(this.holder.getFont(), stack, mouseX, mouseY);
            }
        }
    }
}

