/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.guidebook.obj;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookPage;
import jp.jurassicsaga.client.base.screen.obj.guidebook.GuidebookScreen;
import jp.jurassicsaga.client.base.screen.obj.widget.EmptyButton;
import jp.jurassicsaga.client.base.screen.obj.widget.NoClickHoverClickButton;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSEntityDataHolder;
import jp.jurassicsaga.server.base.animal.entity.obj.info.AnimalGrowthStage;
import jp.jurassicsaga.server.base.animal.entity.obj.other.JSVariants;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGene;
import jp.jurassicsaga.server.base.generic.gene.JSGenetics;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.obj.EggType;
import mod.azure.azurelib.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehaviors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import travelers.server.animal.obj.TravelersAnimalAttributes;

public class JournalSubPage
extends GuidebookPage {
    private final JSAnimal<?> animal;
    private final boolean shouldHaveBaby;
    private ItemStack eggItem = null;
    private JSAnimalBase entity;
    private JSAnimalBase entity_baby;

    public JournalSubPage(GuidebookScreen holder, JSAnimal<?> animal) {
        super(holder);
        this.animal = animal;
        this.shouldHaveBaby = animal.getAnimalAttributes().getMiscProperties().isHasBabyGuidebook();
    }

    @Override
    public void init() {
        int i = this.holder.f_96543_ / 2;
        int j = this.holder.f_96544_ / 2;
        this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 133, j - 22, 18, 18, (Component)Component.m_237119_(), press -> {
            this.entity.getModules().getGeneticModule().setMale(true);
            this.holder.m_7856_();
        }, JSCommon.createId("textures/gui/sprites/container/guidebook/male.png"), JSCommon.createId("textures/gui/sprites/container/guidebook/male.png")));
        this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 148, j - 22, 18, 18, (Component)Component.m_237119_(), press -> {
            this.entity.getModules().getGeneticModule().setMale(false);
            this.holder.m_7856_();
        }, JSCommon.createId("textures/gui/sprites/container/guidebook/female.png"), JSCommon.createId("textures/gui/sprites/container/guidebook/female.png")));
        if (this.entity == null || this.entity.getModules() == null) {
            return;
        }
        if (!((String)this.entity.m_20088_().m_135370_(JSEntityDataHolder.textureVariant)).equals(JSVariants.NONE.getName())) {
            this.holder.addButton((AbstractWidget)new NoClickHoverClickButton(i - 8 - 115, j - 22, 18, 18, (Component)Component.m_237119_(), press -> {
                this.entity.m_20088_().m_135381_(JSEntityDataHolder.textureVariant, (Object)JSVariants.NONE.getName());
                this.holder.m_7856_();
            }, JSCommon.createId("textures/gui/sprites/container/guidebook/x_symbol.png"), JSCommon.createId("textures/gui/sprites/container/guidebook/x_symbol.png")));
        }
        int offsetX = 0;
        int offsetY = 0;
        for (JSGene supportedGene : this.animal.getAnimalAttributes().getGeneticProperties().getSupportedGenes()) {
            if (!(supportedGene instanceof JSCosmeticGene)) continue;
            JSCosmeticGene cosmeticGene = (JSCosmeticGene)supportedGene;
            this.holder.addButton((AbstractWidget)new EmptyButton(i - 153 + offsetX, j - 3 + offsetY, 16, 16, (Component)Component.m_237119_(), a -> {
                this.entity.m_20088_().m_135381_(JSEntityDataHolder.textureVariant, (Object)cosmeticGene.getVariant().getName());
                this.holder.m_7856_();
            }));
            if ((offsetX += 17) < 130) continue;
            offsetX = 0;
            offsetY += 20;
        }
    }

    @Override
    public void render(int i, int j, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.entity == null || this.entity_baby == null && this.shouldHaveBaby) {
            this.entity = (JSAnimalBase)((EntityType)this.animal.getEntityType().get()).m_20615_((Level)Minecraft.m_91087_().f_91073_);
            this.entity_baby = this.shouldHaveBaby ? (JSAnimalBase)((EntityType)this.animal.getEntityType().get()).m_20615_((Level)Minecraft.m_91087_().f_91073_) : null;
            this.eggItem = null;
            this.holder.m_7856_();
            return;
        }
        try {
            AzCommand.createRoot((String)"animation.guidebook_pose", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME, (float)99.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)false).sendForEntity((Entity)this.entity);
            if (this.shouldHaveBaby) {
                if (!this.animal.getAnimalAttributes().getMiscProperties().isBabyAnimations()) {
                    AzCommand.createRoot((String)"animation.guidebook_baby_pose", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME, (float)99.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)false).sendForEntity((Entity)this.entity_baby);
                } else {
                    AzCommand.createRoot((String)"animation.guidebook_pose", (AzPlayBehavior)AzPlayBehaviors.HOLD_ON_LAST_FRAME, (float)99.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)false).sendForEntity((Entity)this.entity_baby);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TravelersAnimalAttributes attributes = this.animal.getAnimalAttributes();
        this.entity.getModules().getGrowthStageModule().setMax();
        if (this.shouldHaveBaby) {
            this.entity_baby.getModules().getGrowthStageModule().setGrowthStage(AnimalGrowthStage.BABY);
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack poseStack = guiGraphics.m_280168_();
        float scale_baby = attributes.getMiscProperties().getGuidebookScaling()[0];
        float scale = attributes.getMiscProperties().getGuidebookScaling()[1];
        float offset_baby_z = attributes.getMiscProperties().getGuidebookOffset()[0].f_82470_;
        float offset_baby_y = attributes.getMiscProperties().getGuidebookOffset()[0].f_82471_;
        float offset_z = attributes.getMiscProperties().getGuidebookOffset()[1].f_82470_;
        float offset_y = attributes.getMiscProperties().getGuidebookOffset()[1].f_82471_;
        if (this.shouldHaveBaby) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)(i - 65), (float)(j - 20), 100.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_85841_(21.0f * scale_baby, -21.0f * scale_baby, 21.0f * scale_baby);
            poseStack.m_252880_(1.0f, offset_baby_y, offset_baby_z);
            Minecraft.m_91087_().m_91290_().m_114384_((Entity)this.entity_baby, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        poseStack.m_252880_((float)(i - 65), (float)(j - 20), 100.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        poseStack.m_85841_(21.0f * scale, -21.0f * scale, 21.0f * scale);
        poseStack.m_252880_(0.0f, offset_y, offset_z);
        Minecraft.m_91087_().m_91290_().m_114384_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
        poseStack.m_85849_();
        buffer.m_109911_();
        Font font = this.holder.getFont();
        guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)("entity." + attributes.getModId() + "." + attributes.getAnimalName())), i - 153, j - 102, 6980223);
        guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)("guidebook." + attributes.getModId() + "." + attributes.getAnimalName() + ".scientific_name")), i + 21, j - 102, 6980223);
        guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)("guidebook." + attributes.getModId() + "." + attributes.getAnimalName() + ".source")), i + 21, j + 102, 6980223);
        guiGraphics.m_280554_(font, (FormattedText)Component.m_237115_((String)("guidebook." + attributes.getModId() + "." + attributes.getAnimalName() + ".description")), i + 21, j - 80, 134, 6980223);
        this.renderVariantShowcase(i, j, guiGraphics, mouseX, mouseY, partialTick);
        if (this.eggItem == null) {
            if (this.animal.getItems().getHatched_egg() == null) {
                return;
            }
            this.eggItem = ((Item)this.animal.getItems().getHatched_egg().get()).m_7968_();
        }
        guiGraphics.m_280480_(this.eggItem, i - 27, j + 79);
        if (mouseX > i - 27 && mouseX < i - 27 + 16 && mouseY > j + 79 && mouseY < j + 79 + 16) {
            EggType type = this.animal.getAnimalAttributes().getItemProperties().getEggtype();
            String key = "guidebook.egg_info." + type.toString();
            guiGraphics.m_280557_(this.holder.getFont(), (Component)Component.m_237115_((String)key), mouseX, mouseY);
        }
    }

    private void renderVariantShowcase(int i, int j, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int offsetX = 0;
        int offsetY = 0;
        for (JSGene supportedGene : this.animal.getAnimalAttributes().getGeneticProperties().getSupportedGenes()) {
            if (!(supportedGene instanceof JSCosmeticGene)) continue;
            JSCosmeticGene gene = (JSCosmeticGene)supportedGene;
            Supplier<Item> item = JSGenetics.GENE_ITEMS.get(gene);
            int x = i - 153 + offsetX;
            int y = j - 3 + offsetY;
            guiGraphics.m_280480_(((Item)item.get()).m_7968_(), x, y);
            guiGraphics.m_280370_(this.holder.getFont(), ((Item)item.get()).m_7968_(), x, y);
            if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
                guiGraphics.m_280153_(this.holder.getFont(), ((Item)item.get()).m_7968_(), mouseX, mouseY);
            }
            if ((offsetX += 17) < 130) continue;
            offsetX = 0;
            offsetY += 17;
        }
    }

    public JSAnimal<?> getAnimal() {
        return this.animal;
    }
}

