/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.base.screen.obj.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SliderButton
extends Button {
    private final double minValue;
    private final double maxValue;
    private double currentValue;
    private boolean dragging;
    private final ResourceLocation sliderIcon;
    private static final int HANDLE_WIDTH = 4;
    private static final int HANDLE_HEIGHT = 8;
    private final Button.OnPress updatePos;

    public SliderButton(Button.OnPress updatePos, int x, int y, int width, int height, double minValue, double maxValue, double initial, Component message, ResourceLocation sliderIcon, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, f_252438_);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.currentValue = initial;
        this.sliderIcon = sliderIcon;
        this.updatePos = updatePos;
    }

    public double getValue() {
        return this.currentValue;
    }

    private void updateValue(double mouseX) {
        double relativeX = mouseX - (double)this.m_252754_() - 2.0;
        double effectiveWidth = this.f_93618_ - 4;
        double percent = relativeX / effectiveWidth;
        percent = Math.max(0.0, Math.min(1.0, percent));
        this.currentValue = this.minValue + (this.maxValue - this.minValue) * percent;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double percent = (this.currentValue - this.minValue) / (this.maxValue - this.minValue);
        int handleX = (int)((double)this.m_252754_() + percent * (double)(this.f_93618_ - 4));
        int handleY = this.m_252907_() + (this.f_93619_ - 8) / 2;
        guiGraphics.m_280163_(this.sliderIcon, handleX, handleY, 0.0f, 0.0f, 4, 8, 4, 8);
        if (this.dragging) {
            this.updateValue(mouseX);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
            this.dragging = true;
            this.updateValue(mouseX);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.dragging = false;
        this.updatePos.m_93750_((Button)this);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.updateValue(mouseX);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }
}

