/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.animation;

import java.util.List;
import java.util.function.Supplier;
import jp.jurassicsaga.client.v1.animation.JSAnimationData;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class JSClientAnimator
extends TravelersClientAnimator {
    protected TravelersAnimationData createData() {
        return new JSAnimationData();
    }

    protected void applyTilt(SmartAnimalBase e, float rotSpeed, float maxPitch, float rollIncrement, float maxRoll, float partialTick, Supplier<Boolean> booleanSupplier, List<TravelersBoneState> bones) {
        boolean dirChanged;
        JSAnimationData data = (JSAnimationData)this.boneOffsetCache.computeIfAbsent(e.m_20149_(), id -> this.createData());
        Vec3 vel = e.m_20184_();
        boolean flying = booleanSupplier.get();
        Vec3 prev = data.prevVel != null ? data.prevVel : Vec3.f_82478_;
        data.prevVel = vel;
        Vec3 delta = vel.m_82546_(prev);
        boolean bl = dirChanged = delta.m_165925_() > 1.0E-6;
        if (flying && dirChanged) {
            float yawPrev;
            float yawNow = (float)Math.atan2(vel.f_82479_, vel.f_82481_);
            float yawDiff = Mth.m_14177_((float)((yawNow - (yawPrev = (float)Math.atan2(prev.f_82479_, prev.f_82481_))) * 57.295776f)) * ((float)Math.PI / 180);
            if (Math.abs(yawDiff) < 0.002f) {
                yawDiff = 0.0f;
            }
            float impulse = Mth.m_14036_((float)(yawDiff * 1.1f), (float)(-rollIncrement * 2.5f), (float)(rollIncrement * 2.5f));
            data.tiltRoll += impulse * 0.7f;
            data.tiltRoll = Mth.m_14036_((float)data.tiltRoll, (float)(-maxRoll), (float)maxRoll);
        }
        float pitchTarget = 0.0f;
        if (flying && vel.m_82556_() > 1.0E-8) {
            float speed = (float)Math.max(1.0E-8, vel.m_82553_());
            float vy = (float)(-vel.f_82480_ / (double)speed);
            pitchTarget = Mth.m_14036_((float)(vy * 0.45f), (float)(-maxPitch), (float)maxPitch);
        }
        float fps = Math.max(1, Minecraft.m_91087_().m_260875_());
        float dt = rotSpeed / fps;
        float t = 1.0f - (float)Math.exp(-dt);
        t *= 1.0f + partialTick * 0.5f;
        if (!flying) {
            data.tiltRoll = Mth.m_14179_((float)(t * 0.2f), (float)data.tiltRoll, (float)0.0f);
            pitchTarget = 0.0f;
        } else {
            float decay = (float)Math.pow(0.992f, 60.0f / fps);
            data.tiltRoll *= decay;
        }
        int n = Math.max(1, bones.size());
        for (int i = 0; i < n; ++i) {
            TravelersBoneState b = bones.get(i);
            float w = (float)Math.pow(((float)i + 1.0f) / (float)n, 1.15f);
            float targetX = -pitchTarget * w;
            float targetZ = data.tiltRoll * (1.4f * w);
            float smoothT = 1.0f - (float)Math.exp(-rotSpeed * (1.0f + partialTick * 0.75f) / fps);
            b.angleX += (targetX - b.angleX) * smoothT * 0.4f;
            b.angleZ += (targetZ - b.angleZ) * smoothT * 0.45f;
        }
    }
}

