/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v1.screen.machine;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSTheme;
import jp.jurassicsaga.client.base.screen.obj.machine.GenericScreen;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.obj.egg.BasicSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.genetics.DnaItem;
import jp.jurassicsaga.server.v1.menu.obj.machine.DnaModifierMachineMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DnaModifierMachineScreen
extends GenericScreen<DnaModifierMachineMenu> {
    private static final String BASE_CONTAINER = "textures/gui/container/machine/dna_combinator_gui";
    private static final String BASE_SPRITE = "textures/gui/sprites/machine/dna_modifier/";
    private static final int STEP1_END = 3250;
    private static final int STEP2_END = 6500;
    private static final int FINAL_STEP_END = 6500;
    private float smoothProgress = 0.0f;
    private Entity entity;
    private ItemStack coin;
    private JSGeneData curData;
    private float animalScale = 1.0f;
    private AbstractClientPlayer playerScale;

    public DnaModifierMachineScreen(DnaModifierMachineMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.f_97729_ = 4;
        this.f_97731_ = -5000;
    }

    protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType clickType) {
        super.m_6597_(slot, slotId, mouseButton, clickType);
    }

    private ResourceLocation tex(String path, boolean jp) {
        return new ResourceLocation("jurassicsaga", path + (jp ? "_jp" : "") + ".png");
    }

    protected void m_7286_(GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        boolean jp = this.theme == JSTheme.JP;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        g.m_280218_(this.tex(BASE_CONTAINER, jp), x - 33, y - 28, 0, 0, 240, 194);
        int realProgress = ((DnaModifierMachineMenu)this.f_97732_).getData().m_6413_(0);
        this.smoothProgress = this.lerp(this.smoothProgress, realProgress, 0.2f);
        if (realProgress <= 0) {
            this.renderPreview(g, partialTick, mouseX, mouseY);
            return;
        }
        g.m_280163_(this.tex("textures/gui/sprites/machine/dna_modifier/step_1", jp), x + 3, y + 5, 0.0f, 0.0f, 12, this.getScaled(this.smoothProgress, 0, 3250, 11), 12, 11);
        g.m_280163_(this.tex("textures/gui/sprites/machine/dna_modifier/step_2", jp), x + 3, y + 36, 0.0f, 0.0f, 12, this.getScaled(this.smoothProgress, 3250, 6500, 11), 12, 11);
    }

    private void renderPreview(GuiGraphics g, float partialTick, int mouseX, int mouseY) {
        LivingEntity living;
        Minecraft mc;
        block18: {
            block17: {
                Entity data;
                GenderSpawnEgg egg;
                JSGeneData coinData;
                ItemStack currentCoin;
                mc = Minecraft.m_91087_();
                ClientLevel level = mc.f_91073_;
                if (level == null) {
                    return;
                }
                if (this.coin == null) {
                    this.coin = (ItemStack)((DnaModifierMachineMenu)this.f_97732_).m_38927_().get(0);
                    return;
                }
                if (this.curData == null) {
                    this.curData = JSGeneUtil.readFromStack(this.coin);
                }
                if ((currentCoin = (ItemStack)((DnaModifierMachineMenu)this.f_97732_).m_38927_().get(0)) != null && !this.curData.isSameAs(coinData = JSGeneUtil.readFromStack(currentCoin))) {
                    this.coin = currentCoin;
                    this.entity = null;
                    this.curData = coinData;
                }
                EntityType type = null;
                Item item = this.coin.m_41720_();
                if (item instanceof DnaItem) {
                    DnaItem dna = (DnaItem)item;
                    type = (EntityType)dna.getAnimal().getEntityType().get();
                } else {
                    item = this.coin.m_41720_();
                    if (item instanceof GenderSpawnEgg) {
                        egg = (GenderSpawnEgg)item;
                        type = (EntityType)egg.getAnimal().getEntityType().get();
                    } else {
                        item = this.coin.m_41720_();
                        if (item instanceof BasicSpawnEgg) {
                            LivingEntity[] egg2 = (LivingEntity[])item;
                            type = (EntityType)egg2.getAnimal().getEntityType().get();
                        }
                    }
                }
                if (type == null) {
                    this.entity = null;
                    return;
                }
                if (this.entity == null || this.entity.m_6095_() != type) {
                    this.entity = type.m_20615_((Level)level);
                    egg = this.entity;
                    if (egg instanceof JSAnimalBase) {
                        JSAnimalBase base = (JSAnimalBase)((Object)egg);
                        data = this.coin.m_41784_();
                        base.getModules().getGeneticModule().setGeneData(JSGeneUtil.fromCompound(data.m_128469_("jsGeneData")));
                        base.getModules().getGrowthStageModule().setMax();
                        base.setStaticCreature(true);
                        base.m_20011_(base.getModules().getGrowthStageModule().makeBoundingBox((JSAnimal<?>)base.getAnimal()));
                        this.animalScale = base.getAnimal().getAnimalAttributes().getMiscProperties().getMachineScale();
                    }
                }
                if (this.playerScale == null) {
                    GameProfile info = new GameProfile(mc.f_91074_.m_20148_(), mc.f_91074_.m_7755_().getString());
                    this.playerScale = new RemotePlayer(level, info);
                }
                if (!((data = this.entity) instanceof LivingEntity)) break block17;
                living = (LivingEntity)data;
                if (this.playerScale != null) break block18;
            }
            return;
        }
        float rot = 180.0f;
        for (LivingEntity e : new LivingEntity[]{this.playerScale, living}) {
            e.m_146922_(rot);
            e.f_20883_ = rot;
            e.f_20885_ = rot;
        }
        float playerH = this.playerScale.m_20206_();
        float entityH = living.m_20206_();
        float maxH = Math.max(playerH, entityH);
        float scale = 35.0f / maxH;
        scale *= this.animalScale;
        PoseStack pose = g.m_280168_();
        MultiBufferSource.BufferSource buf = mc.m_91269_().m_110104_();
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        int boxX = left + 28;
        int boxY = top - 23;
        int boxW = 123;
        int boxH = 96;
        double guiScale = mc.m_91268_().m_85449_();
        int sx = (int)((double)boxX * guiScale);
        int sy = (int)((double)(mc.m_91268_().m_85446_() - (boxY + boxH)) * guiScale);
        int sw = (int)((double)boxW * guiScale);
        int sh = (int)((double)boxH * guiScale);
        RenderSystem.enableScissor((int)sx, (int)sy, (int)sw, (int)sh);
        int centerXLeft = boxX + boxW / 3;
        int centerXRight = boxX + 2 * boxW / 3;
        int groundY = boxY + boxH;
        pose.m_85836_();
        pose.m_252880_((float)centerXLeft, (float)groundY, 100.0f);
        pose.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        pose.m_85841_(scale, -scale, scale);
        mc.m_91290_().m_114384_((Entity)this.playerScale, 0.0, 0.0, 0.0, 0.0f, 0.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_252880_((float)centerXRight, (float)groundY, 100.0f);
        pose.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        pose.m_85841_(scale, -scale, scale);
        mc.m_91290_().m_114384_((Entity)living, 0.0, 0.0, 0.0, 0.0f, 0.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        pose.m_85849_();
        buf.m_109911_();
        RenderSystem.disableScissor();
    }

    private int getScaled(float progress, int start, int end, int size) {
        if (progress <= (float)start) {
            return 0;
        }
        if (progress >= (float)end) {
            return size;
        }
        return (int)((progress - (float)start) * (float)size / (float)(end - start));
    }

    private float lerp(float a, float b, float alpha) {
        return a + (b - a) * alpha;
    }

    @Override
    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float delta) {
        super.m_88315_(g, mouseX, mouseY, delta);
        this.m_280072_(g, mouseX, mouseY);
    }
}

