/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.client.v2.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.v2.model.BasicWireModel;
import jp.jurassicsaga.server.v2.entity.obj.FenceCable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CableRenderer
extends EntityRenderer<FenceCable> {
    private static final ResourceLocation TEXTURE = JSCommon.createId("textures/entity/fence_cable.png");
    protected EntityModel<FenceCable> actualModel;

    public CableRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.actualModel = new BasicWireModel(context.m_174023_(BasicWireModel.LAYER_LOCATION));
    }

    public void render(FenceCable entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        BlockPos b1 = entity.getLink1();
        BlockPos b2 = entity.getLink2();
        if (b1 == null || b2 == null) {
            return;
        }
        Vec3 start = b1.m_252807_();
        Vec3 end = b2.m_252807_();
        Vec3 diff = end.m_82546_(start);
        float distance = (float)diff.m_82553_();
        if (distance < 1.0E-4f) {
            return;
        }
        float MODEL_Z_UNITS = 8.0f;
        float modelBaseLenBlocks = 0.5f;
        float scaleZ = distance / 0.5f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.15, 0.0);
        poseStack.m_252880_(0.0f, -0.03125f, 0.0f);
        float yaw = (float)(Math.atan2(diff.f_82479_, diff.f_82481_) * 57.2957763671875);
        float pitch = (float)(-Math.asin(diff.f_82480_ / (double)distance) * 57.2957763671875);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252880_(0.0f, 0.0f, -distance / 2.0f);
        poseStack.m_85841_(1.0f, 1.0f, scaleZ);
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE));
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FenceCable entity) {
        return TEXTURE;
    }
}

