/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo;

import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.neo.JSModClient;
import jp.jurassicsaga.neo.JSNeoPackets;
import jp.jurassicsaga.neo.data.GatherData;
import jp.jurassicsaga.neo.server.JSNeoMenus;
import jp.jurassicsaga.neo.server.JSNeoTreeGrowers;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.modules.obj.JSHerdModule;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSMiscProperties;
import jp.jurassicsaga.server.base.entity.JSEntities;
import jp.jurassicsaga.server.base.entity.obj.egg.EggEntity;
import jp.jurassicsaga.server.base.item.obj.egg.BasicSpawnEgg;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.world.terrablender.JSTerrablender;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import travelers.util.helper.PlatformHelper;

@Mod(value="jurassicsaga")
public class JSMod {
    public JSMod(FMLJavaModLoadingContext container) {
        IEventBus modEventBus = container.getModEventBus();
        JSCommon.init();
        modEventBus.addListener(GatherData::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            JSModClient.init(modEventBus);
        }
    }

    @Mod.EventBusSubscriber(modid="jurassicsaga", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(JSNeoPackets::registerPackets);
            event.enqueueWork(() -> {
                GenderSpawnEgg.registerDispense();
                BasicSpawnEgg.registerDispense();
                JSV1Blocks.ARAUCARIOXYLON.init();
                JSV1Blocks.GORDONPTERIS.init();
                JSV1Blocks.LEPIDODENDRON.init();
                JSV1Blocks.SPINIFRUCTUS.init();
                JSV2Blocks.DOG_WOOD.init();
                if (PlatformHelper.properties.isModLoaded("terrablender")) {
                    JSTerrablender.init();
                    JSTerrablender.initRegion();
                }
            });
        }

        @SubscribeEvent
        public static void registerSpawns(@NotNull SpawnPlacementRegisterEvent event) {
            for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
                JSMiscProperties misc = animal.getAnimalAttributes().getMiscProperties();
                if (misc.getSpawnPredicate() == null) continue;
                event.register((EntityType)animal.getEntityType().get(), misc.getSpawnPlacementType(), misc.getSpawnHeightMap(), misc.getSpawnPredicate(), SpawnPlacementRegisterEvent.Operation.REPLACE);
            }
        }

        @SubscribeEvent
        public static void registerEvent(RegisterEvent registerEvent) {
            ResourceKey registry = registerEvent.getRegistryKey();
            if (registerEvent.getRegistryKey().equals((Object)ForgeRegistries.Keys.MENU_TYPES)) {
                JSNeoMenus.init(registerEvent);
            }
            if (registry == BuiltInRegistries.f_256920_) {
                JSNeoTreeGrowers.init(registerEvent);
            }
        }

        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)JSEntities.EGG.get(), EggEntity.m_21183_().m_22265_());
        }
    }

    @Mod.EventBusSubscriber(modid="jurassicsaga", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class GameEvents {
        @SubscribeEvent
        public static void onLivingDrops(LivingDropsEvent event) {
            LivingEntity entity;
            DamageSource source = event.getSource();
            Entity entity2 = source.m_7639_();
            if (entity2 instanceof JSAnimalBase) {
                JSAnimalBase base = (JSAnimalBase)entity2;
                event.getDrops().removeIf(drop -> GameEvents.isFoodItem(base, event.getEntity(), drop.m_32055_()));
            }
            if ((entity = event.getEntity()) instanceof Spider) {
                stack = new ItemStack((ItemLike)JSV1Items.SPIDER_EGG.get());
                ItemEntity itemEntity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), stack);
                event.getDrops().add(itemEntity);
            } else if (entity instanceof AbstractFish) {
                stack = new ItemStack((ItemLike)JSV1Items.FISH_EGG.get());
                ItemEntity itemEntity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), stack);
                event.getDrops().add(itemEntity);
            }
        }

        private static boolean isFoodItem(JSAnimalBase base, LivingEntity entity, ItemStack stack) {
            boolean ateItem = base.getModules().getMetabolismModule().getDiet().canEatItem(stack);
            if (ateItem) {
                JSHerdModule herdModule = base.getModules().getHerdModule();
                if (herdModule.isFollower() || herdModule.isLeader()) {
                    if (herdModule.isLeader()) {
                        for (JSAnimalBase follower : herdModule.getFollowers()) {
                            if (!((double)follower.m_20270_((Entity)entity) < 12.5)) continue;
                            follower.getModules().getMetabolismModule().eatItem(stack);
                        }
                        base.getModules().getMetabolismModule().eatItem(stack);
                    } else {
                        JSAnimalBase trueLeader = herdModule.getTrueLeader();
                        for (JSAnimalBase follower : trueLeader.getModules().getHerdModule().getFollowers()) {
                            if (!((double)follower.m_20270_((Entity)entity) < 12.5)) continue;
                            follower.getModules().getMetabolismModule().eatItem(stack);
                        }
                        trueLeader.getModules().getMetabolismModule().eatItem(stack);
                    }
                } else {
                    base.getModules().getMetabolismModule().eatItem(stack);
                }
            }
            return ateItem;
        }
    }
}

