/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo;

import com.mojang.blaze3d.platform.InputConstants;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.client.JSCommonClient;
import jp.jurassicsaga.client.base.particle.DogWoodParticle;
import jp.jurassicsaga.client.base.particle.FeedbackParticle;
import jp.jurassicsaga.client.base.particle.SparkParticle;
import jp.jurassicsaga.client.base.particle.SteamParticle;
import jp.jurassicsaga.client.base.particle.VenomParticle;
import jp.jurassicsaga.client.base.renderer.JSRenderers;
import jp.jurassicsaga.client.base.renderer.entity.JSBoatRenderer;
import jp.jurassicsaga.client.base.renderer.layer.LuxLayer;
import jp.jurassicsaga.client.base.renderer.model.BallModel;
import jp.jurassicsaga.client.base.renderer.model.HaybaleModel;
import jp.jurassicsaga.client.base.renderer.model.MeatModel;
import jp.jurassicsaga.client.base.renderer.model.VenomSpitModel;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSBoatModel;
import jp.jurassicsaga.client.base.renderer.model.vanilla.JSChestBoatModel;
import jp.jurassicsaga.client.v2.model.BasicWireModel;
import jp.jurassicsaga.neo.JSNeoClientPlatform;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.block.obj.plant.JSBasicTriplePlant;
import jp.jurassicsaga.server.base.block.obj.plant.TripleBlockPart;
import jp.jurassicsaga.server.base.entity.obj.other.SeatEntity;
import jp.jurassicsaga.server.base.entity.obj.vanilla.JSBoatEntity;
import jp.jurassicsaga.server.base.generic.gene.JSGeneUtil;
import jp.jurassicsaga.server.base.generic.gene.obj.JSCosmeticGene;
import jp.jurassicsaga.server.base.generic.gene.obj.JSGeneData;
import jp.jurassicsaga.server.base.item.obj.egg.GenderSpawnEgg;
import jp.jurassicsaga.server.base.particle.JSParticles;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class JSModClient {
    public static void init(IEventBus modEventBus) {
        JSCommonClient.init();
    }

    @Mod.EventBusSubscriber(modid="jurassicsaga", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            for (JSBoatEntity.CustomType boat$type : JSBoatEntity.CustomType.values()) {
                event.registerLayerDefinition(JSBoatRenderer.createBoatModelName(boat$type), JSBoatModel::createBodyModel);
                event.registerLayerDefinition(JSBoatRenderer.createChestBoatModelName(boat$type), JSChestBoatModel::createBodyModel);
            }
        }

        @SubscribeEvent
        public static void registerColors(RegisterColorHandlersEvent.Item event) {
            event.register((p_92705_, p_92706_) -> FoliageColor.m_46107_((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)JSV2Blocks.ELEPHANT_GRASS.get()});
        }

        @SubscribeEvent
        public static void registerColors(RegisterColorHandlersEvent.Block event) {
            event.register((p_276233_, p_276234_, p_276235_, p_276236_) -> p_276234_ != null && p_276235_ != null ? BiomeColors.m_108804_((BlockAndTintGetter)p_276234_, (BlockPos)(p_276233_.m_61143_(JSBasicTriplePlant.PART) == TripleBlockPart.UPPER ? p_276235_.m_7495_().m_7495_() : (p_276233_.m_61143_(JSBasicTriplePlant.PART) == TripleBlockPart.MIDDLE ? p_276235_.m_7495_() : p_276235_))) : FoliageColor.m_46113_(), new Block[]{(Block)JSV2Blocks.ELEPHANT_GRASS.get()});
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)JSParticles.VENOM_SPIT.get(), VenomParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.DOG_WOOD.get(), DogWoodParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.STEAM.get(), SteamParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.SPARK.get(), SparkParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.HUNGRY.get(), FeedbackParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.PANIC.get(), FeedbackParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.RAGE.get(), FeedbackParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.THIRSTY.get(), FeedbackParticle.Provider::new);
            event.registerSpriteSet((ParticleType)JSParticles.ZZZ.get(), FeedbackParticle.Provider::new);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerSpawnEggColors(RegisterColorHandlersEvent.Item event) {
            for (GenderSpawnEgg modEgg : GenderSpawnEgg.getMOD_EGGS()) {
                event.register((itemStack, layer) -> {
                    JSGeneData geneData = JSGeneUtil.readFromStack(itemStack);
                    if (geneData.getFirstCosmetic().isPresent()) {
                        JSCosmeticGene cosmeticGene = (JSCosmeticGene)geneData.getFirstCosmetic().get();
                        int rgb = layer == 0 ? cosmeticGene.getColor1() : cosmeticGene.getColor2();
                        return FastColor.ARGB32.m_13660_((int)255, (int)(rgb >> 16 & 0xFF), (int)(rgb >> 8 & 0xFF), (int)(rgb & 0xFF));
                    }
                    CompoundTag tag = itemStack.m_41784_();
                    int tagMode = tag.m_128451_("spawn_type");
                    GenderSpawnEgg.SpawnEggMode mode = GenderSpawnEgg.getSpawnEggMode(tagMode);
                    int rgb = mode == GenderSpawnEgg.SpawnEggMode.FEMALE ? (layer == 0 ? modEgg.backgroundColorFemale : modEgg.highlightColorFemale) : (layer == 0 ? modEgg.backGroundColorMale : modEgg.highlightColorMale);
                    return FastColor.ARGB32.m_13660_((int)255, (int)(rgb >> 16 & 0xFF), (int)(rgb >> 8 & 0xFF), (int)(rgb & 0xFF));
                }, new ItemLike[]{modEgg});
            }
        }

        @SubscribeEvent
        public static void registerScreens(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                for (JSNeoClientPlatform.ScreenRecord<? extends AbstractContainerMenu, ? extends Screen> screenRecord : JSNeoClientPlatform.screenList) {
                    ModEvents.registerScreen(screenRecord);
                }
            });
        }

        @SubscribeEvent
        public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(JSRenderers.VENOM_SPIT, VenomSpitModel::createBodyLayer);
            event.registerLayerDefinition(JSRenderers.MEAT, MeatModel::createBodyLayer);
            event.registerLayerDefinition(JSRenderers.BALL, BallModel::createBodyLayer);
            event.registerLayerDefinition(JSRenderers.HAYBALE, HaybaleModel::createBodyLayer);
            event.registerLayerDefinition(BasicWireModel.LAYER_LOCATION, BasicWireModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            for (JSAnimal<?> value : JSAnimals.getAnimals()) {
                if (!value.getAnimalAttributes().getMiscProperties().isExtinct()) continue;
                String modId = value.getAnimalAttributes().getModId();
                event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation(modId, "signs/paddock/" + value.getAnimalAttributes().getAnimalName()), "inventory"));
            }
        }

        private static <M extends AbstractContainerMenu, U extends Screen> void registerScreen(JSNeoClientPlatform.ScreenRecord<?, ?> raw) {
            JSNeoClientPlatform.ScreenRecord<?, ?> rec = raw;
            MenuScreens.m_96206_(rec.getType().get(), rec.getConstructor()::create);
        }
    }

    @Mod.EventBusSubscriber(modid="jurassicsaga", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class GameEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            Entity entity2;
            LocalPlayer player;
            long window;
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            if (Minecraft.m_91087_().f_91073_ != null) {
                Minecraft.m_91087_().f_91073_.m_104735_().forEach(entity -> {
                    if (entity.m_213877_() || !entity.m_6084_()) {
                        LuxLayer.previousBrightness.remove(entity.m_20148_());
                    }
                });
            }
            if ((window = mc.m_91268_().m_85439_()) == 0L) {
                return;
            }
            boolean bl = JSCommon.isShiftKeyDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
            if (JSCommon.config.rotateHeadWithVehicle && (player = mc.f_91074_).m_20202_() != null && (entity2 = player.m_20202_()) instanceof SeatEntity) {
                SeatEntity e = (SeatEntity)entity2;
                float targetYaw = e.lerpTargetYRot();
                player.m_146922_(targetYaw);
                player.f_19859_ = targetYaw;
            }
        }
    }
}

