/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.client;

import com.google.common.base.Supplier;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.neo.data.JSData;
import jp.jurassicsaga.neo.data.obj.LayerModelDataObject;
import jp.jurassicsaga.neo.data.obj.SignDataObject;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.block.obj.JSBlockStateProperties;
import jp.jurassicsaga.server.base.block.obj.plant.JSBasicTriplePlant;
import jp.jurassicsaga.server.base.block.obj.plant.JSTallPlantBlock;
import jp.jurassicsaga.server.base.block.obj.plant.SegmentPart;
import jp.jurassicsaga.server.base.block.obj.plant.TripleBlockPart;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class JSModelProvider {

    public static class Item
    extends ItemModelProvider {
        public Item(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "jurassicsaga", existingFileHelper);
        }

        protected void registerModels() {
            JSData.getBLOCKS().forEach((blockRegistryObject, translationObject) -> {
                ResourceLocation location = new ResourceLocation("jurassicsaga", translationObject.getGetFolderPrefix() + translationObject.getPrefix() + BuiltInRegistries.f_256975_.m_7981_((Object)((net.minecraft.world.level.block.Block)blockRegistryObject.get())).m_135815_() + translationObject.getSuffix());
                switch (translationObject.getItemModelType()) {
                    case PARENT: {
                        this.createParent((Supplier<net.minecraft.world.level.block.Block>)blockRegistryObject);
                        break;
                    }
                    case SPAWN_EGG: {
                        ((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.level.block.Block)blockRegistryObject.get()).m_5456_()).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
                        break;
                    }
                    case INVENTORY_MODEL: {
                        this.createSuffixedParent((Supplier<net.minecraft.world.level.block.Block>)blockRegistryObject, "_inventory");
                        break;
                    }
                    case INVENTORY_MODEL_TRANSPERNT: {
                        this.createTransparentSuffixedParent((Supplier<net.minecraft.world.level.block.Block>)blockRegistryObject, "_inventory");
                        break;
                    }
                    case TRAPDOOR: {
                        this.createTransparentSuffixedParent((Supplier<net.minecraft.world.level.block.Block>)blockRegistryObject, "_bottom");
                        break;
                    }
                    case SIMPLE_ITEM: {
                        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.level.block.Block)blockRegistryObject.get()).m_5456_()).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(location.m_135827_(), "item/" + location.m_135815_()));
                        break;
                    }
                    case TRANSLUCENT_ITEM: {
                        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.level.block.Block)blockRegistryObject.get()).m_5456_()).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(location.m_135827_(), "item/" + location.m_135815_()))).renderType("translucent");
                        break;
                    }
                    case BLOCK_TEXTURE_AS_TEXTURE: {
                        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.level.block.Block)blockRegistryObject.get()).m_5456_()).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(location.m_135827_(), "block/" + location.m_135815_()))).renderType("translucent");
                        break;
                    }
                    case DOUBLE_PLANT: {
                        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.level.block.Block)blockRegistryObject.get()).m_5456_()).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(location.m_135827_(), "block/" + location.m_135815_() + "_top"))).renderType("translucent");
                        break;
                    }
                    case SEGMENTED: {
                        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.level.block.Block)blockRegistryObject.get()).m_5456_()).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(location.m_135827_(), "block/" + location.m_135815_() + "_segment1"))).renderType("translucent");
                    }
                }
            });
            JSData.getITEMS().forEach((itemDeferredItem, translationObject) -> {
                if (itemDeferredItem != null) {
                    ResourceLocation location = new ResourceLocation("jurassicsaga", translationObject.getGetFolderPrefix() + translationObject.getPrefix() + (!translationObject.getOverrideName().equals("none") ? translationObject.getOverrideName() : BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.item.Item)itemDeferredItem.get())).m_135815_()) + translationObject.getSuffix());
                    switch (translationObject.getType()) {
                        case EMPTY: {
                            break;
                        }
                        case COIN: {
                            if (!(translationObject instanceof LayerModelDataObject)) break;
                            LayerModelDataObject layerModelDataObject = (LayerModelDataObject)translationObject;
                            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.item.Item)itemDeferredItem.get())).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(location.m_135827_(), "item/" + translationObject.getGetFolderPrefix() + translationObject.getPrefix() + translationObject.getSuffix()))).texture("layer1", new ResourceLocation(location.m_135827_(), "item/" + layerModelDataObject.getLayerPath(0)));
                            break;
                        }
                        case SPAWN_EGG: {
                            ((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.item.Item)itemDeferredItem.get())).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
                            break;
                        }
                        default: {
                            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)((net.minecraft.world.item.Item)itemDeferredItem.get())).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(location.m_135827_(), "item/" + location.m_135815_()));
                        }
                    }
                }
            });
            for (JSAnimal<?> value : JSAnimals.getAnimals()) {
                if (!value.getAnimalAttributes().getMiscProperties().isExtinct()) continue;
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/signs/paddock/" + value.getAnimalAttributes().getAnimalName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "block/manmade/other/paddock_sign/" + value.getAnimalAttributes().getAnimalName());
            }
        }

        private void createParent(Supplier<net.minecraft.world.level.block.Block> handler) {
            String path = BuiltInRegistries.f_256975_.m_7981_((Object)((net.minecraft.world.level.block.Block)handler.get())).m_135815_();
            this.withExistingParent(path, this.modLoc("block/" + path));
        }

        private void createSuffixedParent(Supplier<net.minecraft.world.level.block.Block> handler, String suffix) {
            String path = BuiltInRegistries.f_256975_.m_7981_((Object)((net.minecraft.world.level.block.Block)handler.get())).m_135815_();
            this.withExistingParent(path, this.modLoc("block/" + path + suffix));
        }

        private void createTransparentSuffixedParent(Supplier<net.minecraft.world.level.block.Block> handler, String suffix) {
            String path = BuiltInRegistries.f_256975_.m_7981_((Object)((net.minecraft.world.level.block.Block)handler.get())).m_135815_();
            ((ItemModelBuilder)this.withExistingParent(path, this.modLoc("block/" + path + suffix))).renderType("translucent");
        }
    }

    public static class Block
    extends BlockStateProvider {
        public Block(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "jurassicsaga", existingFileHelper);
        }

        protected void registerStatesAndModels() {
            JSData.getBLOCKS().forEach((blockRegistryObject, dataObject) -> {
                net.minecraft.world.level.block.Block block = (net.minecraft.world.level.block.Block)blockRegistryObject.get();
                ResourceLocation location = new ResourceLocation("jurassicsaga", "block/" + dataObject.getGetFolderPrefix() + dataObject.getPrefix() + (String)(!dataObject.getOverrideName().equals("none") ? dataObject.getOverrideName() : BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_() + dataObject.getSuffix()));
                switch (dataObject.getModelType()) {
                    case PARTICLE: {
                        this.getVariantBuilder(block).forAllStatesExcept(blockState -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", location)).build(), new Property[0]);
                        break;
                    }
                    case POTTED: {
                        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture(this.name(block), new ResourceLocation("flower_pot_cross"), "plant", location)).renderType("cutout_mipped")).ao(false));
                        break;
                    }
                    case SIMPLE_BLOCK: {
                        this.simpleBlock(block, (ModelFile)this.models().cubeAll(this.name(block), location));
                        break;
                    }
                    case SIMPLE_WITH_TOP: {
                        this.simpleBlock(block, (ModelFile)this.models().cubeTop(this.name(block), location, location.m_266382_("_top")));
                        break;
                    }
                    case SIMPLE_WITH_TOP_BOTTOM: {
                        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), location, location.m_266382_("_bottom"), location.m_266382_("_top")));
                        break;
                    }
                    case SIMPLE_WITH_TOP_BOTTOM_SAME_AS_SIDE: {
                        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), location, location, location.m_266382_("_top")));
                        break;
                    }
                    case PILLAR_BLOCK: {
                        if (block instanceof RotatedPillarBlock) {
                            RotatedPillarBlock block1 = (RotatedPillarBlock)block;
                            ModelBuilder vertical = this.models().cubeColumn(this.name(block), location, location.m_266382_("_top"));
                            ModelBuilder horizontal = this.models().cubeColumnHorizontal(this.name(block), location, location.m_266382_("_top"));
                            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)vertical).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)horizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(90).addModel();
                            break;
                        }
                        if (!(block instanceof InfestedRotatedPillarBlock)) break;
                        InfestedRotatedPillarBlock block1 = (InfestedRotatedPillarBlock)block;
                        ModelBuilder vertical = this.models().cubeColumn(this.name(block), location, location.m_266382_("_top"));
                        ModelBuilder horizontal = this.models().cubeColumnHorizontal(this.name(block), location, location.m_266382_("_top"));
                        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)vertical).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)horizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)horizontal).rotationX(90).rotationY(90).addModel();
                        break;
                    }
                    case TRAPDOOR: {
                        this.trapdoorBlockWithRenderType((TrapDoorBlock)block, location, true, "cutout");
                        break;
                    }
                    case DOOR: {
                        this.doorBlockWithRenderType((DoorBlock)block, location.m_266382_("_lower"), location.m_266382_("_upper"), "cutout");
                        break;
                    }
                    case ALL_SIDES: {
                        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cube(this.name(block), location.m_266382_("_down"), location.m_266382_("_up"), location.m_266382_("_side_1"), location.m_266382_("_side_2"), location.m_266382_("_side_3"), location.m_266382_("_side_4"))).texture("particle", location.m_266382_("_side_1")));
                        break;
                    }
                    case IRONBAR: {
                        this.paneBlock((IronBarsBlock)block, location, location.m_266382_("_frame"));
                        break;
                    }
                    case SIMPLE_TRANSLUCENT_BLOCK: {
                        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block), location)).renderType("translucent"));
                        break;
                    }
                    case SIMPLE_TRANSPARENT_BLOCK: {
                        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block), location)).renderType("transparent"));
                        break;
                    }
                    case DOOR_TRANSLUCENT: {
                        this.doorBlockWithRenderType((DoorBlock)block, location.m_266382_("_lower"), location.m_266382_("_upper"), "translucent");
                        break;
                    }
                    case DOOR_TRANSLUCENT_SIDE: {
                        ModelBuilder bottomLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_bottom_left", JSCommon.createId("block/door_bottom_left"))).texture("1", location.m_266382_("_lower"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        ModelBuilder bottomLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_bottom_left_open", JSCommon.createId("block/door_bottom_left_open"))).texture("1", location.m_266382_("_lower"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        ModelBuilder bottomRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_bottom_right", JSCommon.createId("block/door_bottom_right"))).texture("1", location.m_266382_("_lower"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        ModelBuilder bottomRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_bottom_right_open", JSCommon.createId("block/door_bottom_right_open"))).texture("1", location.m_266382_("_lower"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        ModelBuilder topLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_top_left", JSCommon.createId("block/door_top_left"))).texture("1", location.m_266382_("_upper"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        ModelBuilder topLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_top_left_open", JSCommon.createId("block/door_top_left_open"))).texture("1", location.m_266382_("_upper"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        ModelBuilder topRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_top_right", JSCommon.createId("block/door_top_right"))).texture("1", location.m_266382_("_upper"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        ModelBuilder topRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_top_right_open", JSCommon.createId("block/door_top_right_open"))).texture("1", location.m_266382_("_upper"))).texture("2", location.m_266382_("_side"))).texture("particle", location.m_266382_("_upper"))).renderType("translucent");
                        this.doorBlock((DoorBlock)block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
                        break;
                    }
                    case TRAPDOOR_TRANSLUCENT: {
                        this.trapdoorBlockWithRenderType((TrapDoorBlock)block, location, true, "translucent");
                        break;
                    }
                    case IRONBAR_TRANSLUCENT: {
                        this.paneBlockWithRenderType((IronBarsBlock)block, location, location.m_266382_("_frame"), "translucent");
                        break;
                    }
                    case WALL: {
                        this.wallBlock((WallBlock)block, (ModelFile)this.models().wallPost(this.name(block) + "_post", location), (ModelFile)this.models().wallSide(this.name(block) + "_side", location), (ModelFile)this.models().wallSideTall(this.name(block) + "_side_tall", location));
                        this.models().wallInventory(this.name(block) + "_inventory", location);
                        break;
                    }
                    case VANILLA_BENCH: {
                        BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "jurassicsaga:block/bench")).texture("plank_texture", new ResourceLocation(location.m_266382_("_planks").m_135815_()));
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)base).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).uvLock(false).build(), new Property[0]);
                        break;
                    }
                    case BENCH: {
                        BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "jurassicsaga:block/bench")).texture("plank_texture", location.m_266382_("_planks"));
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)base).rotationY((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).uvLock(false).build(), new Property[0]);
                        break;
                    }
                    case CARPET: {
                        BlockModelBuilder all = (BlockModelBuilder)((BlockModelBuilder)this.models().carpet("block/" + this.name(block), location)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)all).uvLock(false).build(), new Property[0]);
                        break;
                    }
                    case LILY_PAD: {
                        BlockModelBuilder all = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block), new ResourceLocation("block/lily_pad"), location)).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)all).uvLock(true).build(), new Property[0]);
                        break;
                    }
                    case LILY_PAD_VARIANTS_2: {
                        BlockModelBuilder all = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block), new ResourceLocation("block/lily_pad"), location)).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder all_var1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block) + "_variant", new ResourceLocation("block/lily_pad"), location.m_266382_("_variant"))).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)all).uvLock(true).nextModel().modelFile((ModelFile)all_var1).uvLock(true).build(), new Property[0]);
                        break;
                    }
                    case LILY_PAD_VARIANTS_3: {
                        BlockModelBuilder all = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block), new ResourceLocation("block/lily_pad"), location)).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder all_var1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block) + "_variant1", new ResourceLocation("block/lily_pad"), location.m_266382_("_variant1"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder all_var2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block) + "_variant2", new ResourceLocation("block/lily_pad"), location.m_266382_("_variant2"))).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)all).uvLock(true).nextModel().modelFile((ModelFile)all_var1).uvLock(true).nextModel().modelFile((ModelFile)all_var2).uvLock(true).build(), new Property[0]);
                        break;
                    }
                    case BASIC_TRIPLE_PLANT: {
                        BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_top", location.m_266382_("_top"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder middle = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_middle", location.m_266382_("_middle"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_bottom", location.m_266382_("_bottom"))).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            BlockModelBuilder model = bottom;
                            if (state.m_61143_(JSBasicTriplePlant.PART) == TripleBlockPart.UPPER) {
                                model = top;
                            } else if (state.m_61143_(JSBasicTriplePlant.PART) == TripleBlockPart.MIDDLE) {
                                model = middle;
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)model).uvLock(true).build();
                        }, new Property[0]);
                        break;
                    }
                    case BASIC_TRIPLE_PLANT_TINTED: {
                        BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block) + "_top", ResourceLocation.withDefaultNamespace((String)"block/tinted_cross"), "cross", location.m_266382_("_top"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder middle = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block) + "_middle", ResourceLocation.withDefaultNamespace((String)"block/tinted_cross"), "cross", location.m_266382_("_middle"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().singleTexture("plant/" + this.name(block) + "_bottom", ResourceLocation.withDefaultNamespace((String)"block/tinted_cross"), "cross", location.m_266382_("_bottom"))).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            BlockModelBuilder model = bottom;
                            if (state.m_61143_(JSBasicTriplePlant.PART) == TripleBlockPart.UPPER) {
                                model = top;
                            } else if (state.m_61143_(JSBasicTriplePlant.PART) == TripleBlockPart.MIDDLE) {
                                model = middle;
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)model).uvLock(true).build();
                        }, new Property[0]);
                        break;
                    }
                    case STAIR: {
                        this.stairsBlock((StairBlock)block, (ModelFile)this.models().stairs(this.name(block), location, location, location), (ModelFile)this.models().stairsInner(this.name(block) + "_inner", location, location, location), (ModelFile)this.models().stairsOuter(this.name(block) + "_outer", location, location, location));
                        break;
                    }
                    case STAIR_TRANSLUCENT: {
                        this.stairsBlock((StairBlock)block, (ModelFile)((BlockModelBuilder)this.models().stairs(this.name(block), location, location, location)).renderType("translucent"), (ModelFile)((BlockModelBuilder)this.models().stairsInner(this.name(block) + "_inner", location, location, location)).renderType("translucent"), (ModelFile)((BlockModelBuilder)this.models().stairsOuter(this.name(block) + "_outer", location, location, location)).renderType("translucent"));
                        break;
                    }
                    case SLAB: {
                        this.slabBlock((SlabBlock)block, (ModelFile)this.models().slab(this.name(block), location, location, location), (ModelFile)this.models().slabTop(this.name(block) + "_top", location, location, location), (ModelFile)this.models().cubeAll(dataObject.getOverrideName(), location));
                        break;
                    }
                    case SLAB_TRANSLUCENT: {
                        this.slabBlock((SlabBlock)block, (ModelFile)((BlockModelBuilder)this.models().slab(this.name(block), location, location, location)).renderType("translucent"), (ModelFile)((BlockModelBuilder)this.models().slabTop(this.name(block) + "_top", location, location, location)).renderType("translucent"), (ModelFile)((BlockModelBuilder)this.models().cubeAll(dataObject.getOverrideName(), location)).renderType("translucent"));
                        break;
                    }
                    case BUTTON: {
                        this.models().buttonInventory(this.name(block) + "_inventory", location);
                        this.buttonBlock((ButtonBlock)block, (ModelFile)this.models().button(this.name(block), location), (ModelFile)this.models().buttonPressed(this.name(block) + "_pressed", location));
                        break;
                    }
                    case FENCE: {
                        this.fourWayBlock((CrossCollisionBlock)((FenceBlock)block), (ModelFile)this.models().fencePost(this.name(block) + "_post", location), (ModelFile)this.models().fenceSide(this.name(block) + "_side", location));
                        this.models().fenceInventory(this.name(block) + "_inventory", location);
                        break;
                    }
                    case LOG_FENCE: {
                        this.fourWayBlock((CrossCollisionBlock)((FenceBlock)block), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_post", "JSMod:block/log_fence_post")).texture("0", location.m_266382_("_log"))).texture("1", location.m_266382_("_log_top")), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_side", "JSMod:block/log_fence_side")).texture("0", location.m_266382_("_log"))).texture("1", location.m_266382_("_log_top")));
                        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_inventory", "JSMod:block/log_fence_inventory")).texture("0", location.m_266382_("_log"))).texture("1", location.m_266382_("_log_top"));
                        break;
                    }
                    case FENCE_GATE: {
                        this.fenceGateBlock((FenceGateBlock)block, (ModelFile)this.models().fenceGate(this.name(block), location), (ModelFile)this.models().fenceGateOpen(this.name(block) + "_open", location), (ModelFile)this.models().fenceGateWall(this.name(block) + "_wall", location), (ModelFile)this.models().fenceGateWallOpen(this.name(block) + "_wall_open", location));
                        break;
                    }
                    case LOG_FENCE_GATE: {
                        BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "JSMod:block/log_fence_gate")).texture("0", location.m_266382_("_log"))).texture("1", location.m_266382_("_log_top"))).texture("2", location.m_266382_("_planks"));
                        BlockModelBuilder baseOpen = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_open", "JSMod:block/log_fence_gate_open")).texture("0", location.m_266382_("_log"))).texture("1", location.m_266382_("_log_top"))).texture("2", location.m_266382_("_planks"));
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            BlockModelBuilder model = base;
                            if (((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue()) {
                                model = baseOpen;
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)((Direction)state.m_61143_((Property)FenceGateBlock.f_54117_)).m_122435_()).uvLock(false).build();
                        }, new Property[]{FenceGateBlock.f_53342_});
                        break;
                    }
                    case SIGN: {
                        if (!(dataObject instanceof SignDataObject)) break;
                        SignDataObject object = (SignDataObject)dataObject;
                        this.signBlock((StandingSignBlock)block, (WallSignBlock)object.getBlock().get(), (ModelFile)this.models().sign(this.name(block), location));
                        break;
                    }
                    case HANGING_SIGN: {
                        if (!(dataObject instanceof SignDataObject)) break;
                        SignDataObject object = (SignDataObject)dataObject;
                        this.getVariantBuilder(block).forAllStatesExcept(blockState -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", location)).build(), new Property[0]);
                        this.getVariantBuilder((net.minecraft.world.level.block.Block)object.getBlock().get()).forAllStatesExcept(blockState -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", location)).build(), new Property[0]);
                        break;
                    }
                    case PRESSURE_PLATE: {
                        this.pressurePlateBlock((PressurePlateBlock)block, (ModelFile)this.models().pressurePlate(this.name(block), location), (ModelFile)this.models().pressurePlateDown(this.name(block) + "_down", location));
                        break;
                    }
                    case PRESSURE_PLATE_TRANSLUCENT: {
                        this.pressurePlateBlock((PressurePlateBlock)block, (ModelFile)((BlockModelBuilder)this.models().pressurePlate(this.name(block), location)).renderType("translucent"), (ModelFile)((BlockModelBuilder)this.models().pressurePlateDown(this.name(block) + "_down", location)).renderType("translucent"));
                        break;
                    }
                    case BASIC_PLANT: {
                        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block), location)).ao(false)).renderType("cutout_mipped"));
                        break;
                    }
                    case COLOR_PLANT: {
                        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.crossTexture("plant/" + this.name(block), location).ao(false)).renderType("cutout_mipped"));
                        break;
                    }
                    case BASIC_PLANT_DOUBLE: {
                        BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_top", location.m_266382_("_top"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_bottom", location.m_266382_("_bottom"))).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            BlockModelBuilder model = bottom;
                            if (state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                                model = top;
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)model).uvLock(true).build();
                        }, new Property[0]);
                        break;
                    }
                    case COLOR_DOUBLE_PLANT: {
                        BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)this.crossTexture("plant/" + this.name(block) + "_top", location.m_266382_("_top")).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)this.crossTexture("plant/" + this.name(block) + "_bottom", location.m_266382_("_bottom")).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            BlockModelBuilder model = bottom;
                            if (state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                                model = top;
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)model).uvLock(true).build();
                        }, new Property[0]);
                        break;
                    }
                    case SEGMENTED: {
                        if (!(block instanceof JSTallPlantBlock)) break;
                        JSTallPlantBlock segmentedPart = (JSTallPlantBlock)block;
                        int maxSize = segmentedPart.getWantedSegmentCount();
                        BlockModelBuilder segment_1 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment1", location.m_266382_("_segment1"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder segment_2 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment2", location.m_266382_("_segment2"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder segment_3 = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment3", location.m_266382_("_segment3"))).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder segment_4 = maxSize >= 4 ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment4", location.m_266382_("_segment4"))).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_5 = maxSize >= 5 ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment5", location.m_266382_("_segment5"))).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_6 = maxSize >= 6 ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment6", location.m_266382_("_segment6"))).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_7 = maxSize >= 7 ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment7", location.m_266382_("_segment7"))).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_8 = maxSize >= 8 ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block) + "_segment8", location.m_266382_("_segment8"))).ao(false)).renderType("cutout_mipped") : null;
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            int curSize = ((SegmentPart)((Object)((Object)((Object)state.m_61143_(JSBlockStateProperties.SEGMENTED))))).getOffset() + 1;
                            if (curSize <= maxSize) {
                                return ConfiguredModel.builder().modelFile((ModelFile)(switch ((SegmentPart)((Object)((Object)((Object)state.m_61143_(JSBlockStateProperties.SEGMENTED))))) {
                                    case SegmentPart.SEGMENT_1 -> segment_1;
                                    case SegmentPart.SEGMENT_2 -> segment_2;
                                    case SegmentPart.SEGMENT_3 -> segment_3;
                                    case SegmentPart.SEGMENT_4 -> segment_4;
                                    case SegmentPart.SEGMENT_5 -> segment_5;
                                    case SegmentPart.SEGMENT_6 -> segment_6;
                                    case SegmentPart.SEGMENT_7 -> segment_7;
                                    default -> segment_8;
                                })).uvLock(true).build();
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)segment_1).uvLock(true).build();
                        }, new Property[0]);
                        break;
                    }
                    case SEGMENTED_COLOR: {
                        if (!(block instanceof JSTallPlantBlock)) break;
                        JSTallPlantBlock segmentedPart = (JSTallPlantBlock)block;
                        int maxSize = segmentedPart.getWantedSegmentCount();
                        BlockModelBuilder segment_1 = (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment1", location.m_266382_("_segment1")).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder segment_2 = (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment2", location.m_266382_("_segment2")).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder segment_3 = (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment3", location.m_266382_("_segment3")).ao(false)).renderType("cutout_mipped");
                        BlockModelBuilder segment_4 = maxSize >= 4 ? (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment4", location.m_266382_("_segment4")).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_5 = maxSize >= 5 ? (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment5", location.m_266382_("_segment5")).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_6 = maxSize >= 6 ? (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment6", location.m_266382_("_segment6")).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_7 = maxSize >= 7 ? (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment7", location.m_266382_("_segment7")).ao(false)).renderType("cutout_mipped") : null;
                        BlockModelBuilder segment_8 = maxSize >= 8 ? (BlockModelBuilder)((BlockModelBuilder)this.crossTextureTall("plant/" + this.name(block) + "_segment8", location.m_266382_("_segment8")).ao(false)).renderType("cutout_mipped") : null;
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            int curSize = ((SegmentPart)((Object)((Object)((Object)state.m_61143_(JSBlockStateProperties.SEGMENTED))))).getOffset() + 1;
                            if (curSize <= maxSize) {
                                return ConfiguredModel.builder().modelFile((ModelFile)(switch ((SegmentPart)((Object)((Object)((Object)state.m_61143_(JSBlockStateProperties.SEGMENTED))))) {
                                    case SegmentPart.SEGMENT_1 -> segment_1;
                                    case SegmentPart.SEGMENT_2 -> segment_2;
                                    case SegmentPart.SEGMENT_3 -> segment_3;
                                    case SegmentPart.SEGMENT_4 -> segment_4;
                                    case SegmentPart.SEGMENT_5 -> segment_5;
                                    case SegmentPart.SEGMENT_6 -> segment_6;
                                    case SegmentPart.SEGMENT_7 -> segment_7;
                                    default -> segment_8;
                                })).uvLock(true).build();
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)segment_1).uvLock(true).build();
                        }, new Property[0]);
                        break;
                    }
                    case ANCIENT_BUSH: {
                        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/bush/" + this.name(block), location)).ao(false)).renderType("cutout_mipped"));
                        break;
                    }
                    case BASIC_AQUATIC_PLANT: 
                    case CORAL: {
                        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().cross("plant/" + this.name(block), location)).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)model).uvLock(true).build(), new Property[0]);
                        break;
                    }
                    case CORAL_FAN: {
                        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("plant/" + this.name(block), "coral_fan")).texture("fan", location)).ao(false)).renderType("cutout_mipped");
                        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)model).uvLock(false).build(), new Property[0]);
                        break;
                    }
                    case CORAL_FAN_WALL: {
                        this.getVariantBuilder(block).forAllStatesExcept(state -> {
                            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("plant/" + this.name(block), "coral_wall_fan")).texture("fan", location)).ao(false)).renderType("cutout_mipped");
                            Direction dir = (Direction)state.m_61143_((Property)BaseCoralWallFanBlock.f_49192_);
                            if (dir == Direction.NORTH) {
                                return ConfiguredModel.builder().modelFile((ModelFile)model).uvLock(true).build();
                            }
                            int y = 0;
                            switch (dir) {
                                case EAST: {
                                    y = 90;
                                    break;
                                }
                                case SOUTH: {
                                    y = 180;
                                    break;
                                }
                                case WEST: {
                                    y = 270;
                                }
                            }
                            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(y).build();
                        }, new Property[0]);
                    }
                }
            });
        }

        private String name(net.minecraft.world.level.block.Block block) {
            return BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
        }

        public BlockModelBuilder crossTexture(String name, ResourceLocation cross) {
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, JSCommon.createId("plant/layered_cross"))).texture("flower", cross.m_266382_("_colour"))).texture("stem", cross.m_266382_("_greyscale"));
        }

        public BlockModelBuilder crossTextureTall(String name, ResourceLocation cross) {
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, JSCommon.createId("plant/layered_cross"))).texture("flower", cross.m_266382_("_colour_layer"))).texture("stem", cross.m_266382_("_greyscale"));
        }
    }
}

