/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server;

import com.google.common.base.Supplier;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import jp.jurassicsaga.JSCommon;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.generic.Versions;
import jp.jurassicsaga.server.base.generic.obj.Era;
import jp.jurassicsaga.server.base.generic.obj.PossibleResult;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.animal.JSV1Animals;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class JSAchievementProvider
implements AdvancementSubProvider {
    public void m_245571_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull Consumer<Advancement> saver) {
        this.welcomeAchievement(saver);
        this.fossils(saver);
        this.machines(saver);
        this.hatchedEgg(saver);
        this.createVersion(saver, Versions.VERSION_1, Versions.VERSION_2);
        for (JSAnimal<?> animal : JSAnimals.getAnimals()) {
            if (!animal.getAnimalAttributes().getMiscProperties().isExtinct()) continue;
            this.createAnimal(saver, animal);
        }
    }

    private void createVersion(Consumer<Advancement> saver, Versions.Version ... versions) {
        for (Versions.Version v : versions) {
            Advancement.Builder builder = Advancement.Builder.m_138353_();
            AtomicReference<ItemStack> stack = new AtomicReference<ItemStack>(((Item)JSV1Items.PADDOCK_SIGN.get()).m_7968_());
            Optional<JSAnimal> value = JSAnimals.getAnimals().stream().filter(animal -> animal.getAnimalAttributes().getMiscProperties().isExtinct() && animal.getAnimalAttributes().getMiscProperties().getVersion() == v && animal.getItems().getFossil_remains() != null).findFirst();
            value.ifPresent(animal -> stack.set(((Item)animal.getItems().getFossil_remains().get()).m_7968_()));
            builder.m_138371_(() -> ((ItemStack)stack.get()).m_41720_(), (Component)Component.m_237115_((String)("advancements.js.v" + v.versionId() + ".title")), (Component)Component.m_237115_((String)("advancements.js.v" + v.versionId() + ".desc")), JSCommon.createId("textures/gui/advancements/backgrounds/v" + v.versionId() + ".png"), FrameType.TASK, true, true, false);
            builder.m_138386_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(JSItemTags.V1_ANIMALS).m_45077_()}));
            builder.m_138389_(saver, this.createId("base/v" + v.versionId()));
        }
    }

    private void createAnimal(Consumer<Advancement> saver, JSAnimal<? extends JSAnimalBase> animal) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        String name = animal.getAnimalAttributes().getAnimalName();
        Supplier<Item> hatchedEgg = animal.getItems().getHatched_egg();
        if (hatchedEgg == null) {
            return;
        }
        Supplier<Item> item = animal.getItems().getCoin();
        ItemStack actualItem = ItemStack.f_41583_;
        actualItem = item != null ? ((Item)item.get()).m_7968_() : ((Item)JSV1Items.FAILED_EGG.get()).m_7968_();
        builder.m_138362_(actualItem, (Component)Component.m_237115_((String)("advancements.js." + name + ".title")), (Component)Component.m_237115_((String)("advancements.js." + name + ".desc")), JSCommon.createId("textures/gui/advancements/backgrounds/v" + animal.getAnimalAttributes().getMiscProperties().getVersion().versionId() + ".png"), FrameType.CHALLENGE, true, true, true);
        builder.m_138398_(AdvancementSubProvider.m_266597_((String)this.createId("base/v" + animal.getAnimalAttributes().getMiscProperties().getVersion().versionId())));
        builder.m_138386_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)hatchedEgg.get()}).m_45077_()}));
        builder.m_138389_(saver, this.createId("base/animals/v" + animal.getAnimalAttributes().getMiscProperties().getVersion().versionId() + "/" + name));
    }

    private void hatchedEgg(Consumer<Advancement> saver) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        builder.m_138371_(() -> ((Item)JSV1Animals.VELOCIRAPTOR.getItems().getHatched_egg().get()).m_5456_(), (Component)Component.m_237115_((String)"advancements.js.hatched_egg.title"), (Component)Component.m_237115_((String)"advancements.js.hatched_egg.desc"), null, FrameType.TASK, true, true, false);
        builder.m_138398_(AdvancementSubProvider.m_266597_((String)this.createId("base/machines/incubator")));
        builder.m_138386_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(JSItemTags.FERTILIZED_EGGS).m_45077_()}));
        builder.m_138389_(saver, this.createId("base/hatched_egg"));
    }

    private void machines(Consumer<Advancement> saver) {
        Advancement.Builder analyzer = Advancement.Builder.m_138353_();
        analyzer.m_138371_(() -> ((Block)JSV1Blocks.GENETIC_ANALYZER.get()).m_5456_(), (Component)Component.m_237115_((String)"advancements.js.analyzer.title"), (Component)Component.m_237115_((String)"advancements.js.analyzer.desc"), null, FrameType.TASK, true, true, false);
        analyzer.m_138398_(AdvancementSubProvider.m_266597_((String)this.createId("base/fossils")));
        analyzer.m_138386_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)JSV1Blocks.GENETIC_ANALYZER.get()}).m_45077_()}));
        analyzer.m_138389_(saver, this.createId("base/machines/analyzer"));
        Advancement.Builder modifier = Advancement.Builder.m_138353_();
        modifier.m_138371_(() -> ((Block)JSV1Blocks.DNA_MODIFIER.get()).m_5456_(), (Component)Component.m_237115_((String)"advancements.js.modifier.title"), (Component)Component.m_237115_((String)"advancements.js.modifier.desc"), null, FrameType.TASK, true, true, false);
        modifier.m_138398_(AdvancementSubProvider.m_266597_((String)this.createId("base/machines/analyzer")));
        modifier.m_138386_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)JSV1Blocks.DNA_MODIFIER.get()}).m_45077_()}));
        modifier.m_138389_(saver, this.createId("base/machines/modifier"));
        Advancement.Builder incubator = Advancement.Builder.m_138353_();
        incubator.m_138371_(() -> ((Block)JSV1Blocks.INCUBATOR.get()).m_5456_(), (Component)Component.m_237115_((String)"advancements.js.incubator.title"), (Component)Component.m_237115_((String)"advancements.js.incubator.desc"), null, FrameType.TASK, true, true, false);
        incubator.m_138398_(AdvancementSubProvider.m_266597_((String)this.createId("base/machines/analyzer")));
        incubator.m_138386_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)JSV1Blocks.INCUBATOR.get()}).m_45077_()}));
        incubator.m_138389_(saver, this.createId("base/machines/incubator"));
    }

    private void fossils(Consumer<Advancement> saver) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        builder.m_138371_((ItemLike)((Item)Era.JURASSIC.getRegistryMap().get((Object)PossibleResult.CICADA_IN_AMBER).get()).m_5456_(), (Component)Component.m_237115_((String)"advancements.js.fossils.title"), (Component)Component.m_237115_((String)"advancements.js.fossils.desc"), null, FrameType.TASK, true, true, false);
        builder.m_138398_(AdvancementSubProvider.m_266597_((String)this.createId("base/welcome")));
        builder.m_138386_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(JSItemTags.FOSSIL).m_45077_()}));
        builder.m_138389_(saver, this.createId("base/fossils"));
    }

    private void welcomeAchievement(Consumer<Advancement> saver) {
        Advancement.Builder builder = Advancement.Builder.m_138353_();
        builder.m_138371_(() -> ((Item)JSV1Items.PADDOCK_SIGN.get()).m_5456_(), (Component)Component.m_237115_((String)"advancements.js.welcome.title"), (Component)Component.m_237115_((String)"advancements.js.welcome.desc"), JSCommon.createId("textures/gui/advancements/backgrounds/base.png"), FrameType.TASK, true, true, false);
        builder.m_138354_(AdvancementRewards.Builder.m_144822_((ResourceLocation)JSCommon.createId("advancement/welcome_reward")));
        builder.m_138386_("join", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_272050_());
        builder.m_138389_(saver, this.createId("base/welcome"));
    }

    private String createId(String s) {
        return "jurassicsaga:" + s;
    }
}

