/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.data.server;

import com.google.common.base.Supplier;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import jp.jurassicsaga.server.base.animal.JSAnimals;
import jp.jurassicsaga.server.base.animal.obj.JSAnimal;
import jp.jurassicsaga.server.base.animal.obj.attributes.JSItemProperties;
import jp.jurassicsaga.server.base.block.obj.group.BasicBlockSetRegistries;
import jp.jurassicsaga.server.base.block.obj.group.ColoredRegistries;
import jp.jurassicsaga.server.base.block.obj.group.StoneRegistries;
import jp.jurassicsaga.server.base.item.JSItems;
import jp.jurassicsaga.server.base.tag.JSItemTags;
import jp.jurassicsaga.server.v1.block.JSV1Blocks;
import jp.jurassicsaga.server.v1.item.JSV1Items;
import jp.jurassicsaga.server.v2.block.JSV2Blocks;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class JSCraftingProvider
extends RecipeProvider
implements IConditionBuilder {
    public JSCraftingProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> out) {
        this.buildAnimalRecipes(out);
        this.shapeless(out, RecipeCategory.TOOLS, (ItemLike)JSItems.GUIDEBOOK.get(), 1, List.of(Items.f_42517_, JSItemTags.FOSSIL), (ItemLike)Items.f_42517_);
        this.shapeless(out, RecipeCategory.BREWING, (ItemLike)JSV1Items.SYRINGE.get(), 16, List.of(Items.f_41904_, Items.f_42416_), (ItemLike)Items.f_42416_);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.THATCH.get(), 2, Map.of(Items.f_41864_, 4, Items.f_41909_, 4, Items.f_42398_, 1), (ItemLike)Items.f_41864_);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.IRON_PILLAR.get(), 2, Map.of(Items.f_41913_, 2), (ItemLike)Items.f_41913_);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.ROOF_TILES.get(), 2, Map.of(Items.f_41995_, 3, Items.f_42416_, 1), (ItemLike)Items.f_41995_);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.CAMO_NET.get(), 8, Map.of(Items.f_42398_, 5), (ItemLike)Items.f_42398_, List.of(Ingredient.m_204132_((TagKey)ItemTags.f_13143_)));
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.REINFORCED_GLASS.get(), 2, Map.of(((Block)JSV1Blocks.CLEAR_GLASS.get()).m_5456_(), 1, Items.f_42416_, 1), (ItemLike)((Block)JSV1Blocks.CLEAR_GLASS.get()).m_5456_());
        JSCraftingProvider.m_176710_((ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES_STAIR.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.ROOF_TILES.get()})).m_126132_("has_roof_tiles", (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES.get()))).m_176498_(out);
        JSCraftingProvider.m_246658_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.ROOF_TILES.get()));
        this.stairSlabColoredGroup(out, JSV1Blocks.COLORED_ROOF_TILES_STAIRS, JSV1Blocks.COLORED_ROOF_TILES_SLAB, JSV1Blocks.COLORED_ROOF_TILES);
        this.colorGroup(out, JSV1Blocks.COLORED_ROOF_TILES, (Block)JSV1Blocks.ROOF_TILES.get());
        JSCraftingProvider.m_176710_((ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON_STAIR.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.CORRUGATED_IRON.get()})).m_126132_("has_corrugated_iron", (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON.get()))).m_176498_(out);
        JSCraftingProvider.m_246658_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.CORRUGATED_IRON.get()));
        this.colorGroup(out, JSV1Blocks.COLORED_CORRUGATED_IRONS, (Block)JSV1Blocks.CORRUGATED_IRON.get());
        this.stairSlabColoredGroup(out, JSV1Blocks.COLORED_CORRUGATED_IRONS_STAIR, JSV1Blocks.COLORED_CORRUGATED_IRONS_SLAB, JSV1Blocks.COLORED_CORRUGATED_IRONS);
        this.colorGroup(out, JSV1Blocks.COLORED_GLASS_DOORS, (Block)JSV1Blocks.GLASS_DOOR.get());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.BIG_TILE.get(), 3, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.f_42594_, Character.valueOf('S'), Items.f_41830_), (ItemLike)Items.f_41830_);
        JSCraftingProvider.m_176710_((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE_STAIR.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.BIG_TILE.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get())), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get()))).m_176498_(out);
        JSCraftingProvider.m_246658_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.BIG_TILE_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.BIG_TILE.get()));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), 8, new String[]{"CCC", "CBC", "CCC"}, Map.of(Character.valueOf('C'), JSItemTags.CONCRETE, Character.valueOf('B'), Items.f_42025_), (ItemLike)Items.f_42025_);
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get(), 8, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_BRICKS);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_CRACKED.BLOCK.get(), 1, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_(), 1), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_CRACKED);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED.BLOCK.get(), 1, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get()).m_5456_(), 1), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_BRICKS.BLOCK.get()).m_5456_());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_BRICKS_CRACKED);
        this.mossifyBasic(out, JSV1Blocks.FACILITY_CONCRETE_BRICKS, JSV1Blocks.FACILITY_CONCRETE_BRICKS_MOSSY);
        this.mossifyBasic(out, JSV1Blocks.FACILITY_CONCRETE, JSV1Blocks.FACILITY_CONCRETE_MOSSY);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY.BLOCK.get(), 2, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get()).m_5456_(), 8), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get()).m_5456_(), List.of(Ingredient.m_204132_(JSItemTags.MOSS)));
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_PANEL_MOSSY);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PANEL.BLOCK.get(), 2, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_(), 2), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_());
        this.basicFamily(out, JSV1Blocks.FACILITY_CONCRETE_PANEL);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get(), 3, new String[]{"C", "C", "C"}, Map.of(Character.valueOf('C'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_());
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR_CRACKED.get(), 1, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).m_5456_(), 1), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).m_5456_());
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.FACILITY_CONCRETE_PILLAR_MOSSY.get(), 8, Map.of(((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).m_5456_(), 8), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE_PILLAR.get()).m_5456_(), List.of(Ingredient.m_204132_(JSItemTags.MOSS)));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.MIXED_PATH.get(), 3, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.f_42594_, Character.valueOf('S'), Items.f_42329_), (ItemLike)Items.f_42594_);
        JSCraftingProvider.m_176710_((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH_STAIR.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.MIXED_PATH.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get())), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get()))).m_176498_(out);
        JSCraftingProvider.m_246658_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH_SLAB.get()), (ItemLike)((ItemLike)JSV1Blocks.MIXED_PATH.get()));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.CORRUGATED_IRON.get(), 8, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.f_42594_, Character.valueOf('S'), Items.f_42416_), (ItemLike)Items.f_42594_);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get(), 3, new String[]{"CS", "SC"}, Map.of(Character.valueOf('C'), Items.f_42749_, Character.valueOf('S'), Items.f_42025_), (ItemLike)Items.f_42025_);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get(), 3, new String[]{"SS", "SS"}, Map.of(Character.valueOf('S'), Items.f_42025_), (ItemLike)Items.f_42025_);
        JSCraftingProvider.m_176710_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS_STAIRS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get())), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()))).m_176498_(out);
        JSCraftingProvider.m_247552_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS_SLAB.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get())) + "_slab", (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_BARS.get()))).m_176498_(out);
        JSCraftingProvider.m_176710_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID_STAIRS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get())), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()))).m_176498_(out);
        JSCraftingProvider.m_247552_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID_SLAB.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get())) + "_slab", (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.HEAVY_DUTY_GRID.get()))).m_176498_(out);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.CLEAR_GLASS.get(), 3, new String[]{"GG", "GG"}, Map.of(Character.valueOf('G'), Items.f_41904_), (ItemLike)Items.f_41904_);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.GLASS_DOOR.get(), 3, new String[]{"#GG", "#GG", "#GG"}, Map.of(Character.valueOf('#'), ItemTags.f_13168_, Character.valueOf('G'), Items.f_42027_), (ItemLike)Items.f_42027_);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.GRID_DOOR.get(), 2, new String[]{"#", "#", "#"}, Map.of(Character.valueOf('#'), Items.f_42025_), (ItemLike)Items.f_42025_);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.SECURE_GRID_DOOR.get(), 1, Map.of(((Block)JSV1Blocks.GRID_DOOR.get()).m_5456_(), 1, Items.f_42416_, 2), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.LAB_DOOR.get(), 2, new String[]{"P", "#", "#"}, Map.of(Character.valueOf('#'), Items.f_42416_, Character.valueOf('P'), Items.f_42027_), (ItemLike)Items.f_42025_);
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.HIGH_SECURITY_DOOR.get(), 1, Map.of(Blocks.f_50166_.m_5456_(), 1, Items.f_42416_, 4), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.AMBER_BLOCK.get(), 4, new String[]{"CCC", "CCC", "CCC"}, Map.of(Character.valueOf('C'), JSItemTags.AMBER), (ItemLike)Items.f_42594_);
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV1Blocks.THATCH_SLAB.get(), 6, new String[]{"###"}, Map.of(Character.valueOf('#'), JSV1Blocks.THATCH.get()), (ItemLike)((Block)JSV1Blocks.THATCH.get()).m_5456_());
        JSCraftingProvider.m_176710_((ItemLike)((ItemLike)JSV1Blocks.THATCH_STAIRS.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JSV1Blocks.THATCH.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)JSV1Blocks.THATCH.get())), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)JSV1Blocks.THATCH.get()))).m_176498_(out);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Items.EMPTY_TEST_TUBE.get(), 16, new String[]{"#", "#"}, Map.of(Character.valueOf('#'), Items.f_41904_), (ItemLike)Items.f_41904_);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.GENETIC_ANALYZER.get(), 1, new String[]{"PBE", "GAL", "IIL"}, Map.of(Character.valueOf('P'), ItemTags.f_13177_, Character.valueOf('B'), Items.f_42446_, Character.valueOf('E'), JSV1Items.SYRINGE.get(), Character.valueOf('G'), Items.f_42027_, Character.valueOf('A'), Items.f_42025_, Character.valueOf('L'), Items.f_41966_, Character.valueOf('I'), Items.f_42416_), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.GENE_EXTRACTOR.get(), 1, new String[]{"CPI", "LBG", "RSS"}, Map.of(Character.valueOf('C'), Items.f_42496_, Character.valueOf('P'), Items.f_41869_, Character.valueOf('I'), Items.f_42416_, Character.valueOf('L'), Items.f_42534_, Character.valueOf('B'), Items.f_41913_, Character.valueOf('G'), Items.f_42027_, Character.valueOf('R'), Items.f_42451_, Character.valueOf('S'), Items.f_42083_), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.DNA_MODIFIER.get(), 1, new String[]{"CII", "LBG", "RSS"}, Map.of(Character.valueOf('C'), Items.f_42496_, Character.valueOf('I'), Items.f_42416_, Character.valueOf('L'), Items.f_42534_, Character.valueOf('B'), Items.f_41913_, Character.valueOf('G'), Items.f_42027_, Character.valueOf('R'), Items.f_42451_, Character.valueOf('S'), Items.f_42083_), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.INCUBATOR.get(), 1, new String[]{"NGI", "LGP", "LBR"}, Map.of(Character.valueOf('N'), Items.f_42749_, Character.valueOf('I'), Items.f_42416_, Character.valueOf('L'), Items.f_41966_, Character.valueOf('B'), Items.f_41913_, Character.valueOf('P'), Items.f_41869_, Character.valueOf('G'), Items.f_41904_, Character.valueOf('R'), Items.f_42451_), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.BREWING, (ItemLike)JSV1Blocks.CULTIVATOR.get(), 1, new String[]{"IDR", "IPS", "IIS"}, Map.of(Character.valueOf('I'), Items.f_42416_, Character.valueOf('D'), Items.f_42525_, Character.valueOf('R'), Items.f_42451_, Character.valueOf('P'), Items.f_42027_, Character.valueOf('S'), Items.f_42083_), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.BUG_ZAPPER.get(), 1, new String[]{" C ", "IFI", " I "}, Map.of(Character.valueOf('I'), Items.f_42416_, Character.valueOf('C'), Items.f_42026_, Character.valueOf('F'), Items.f_42053_), (ItemLike)Items.f_42416_);
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.HERBIVORE_FEEDER.get(), 1, new String[]{"FPF", "ICI", "FPF"}, Map.of(Character.valueOf('I'), Items.f_42416_, Character.valueOf('C'), Items.f_42009_, Character.valueOf('F'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), Character.valueOf('P'), Items.f_41869_), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_());
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.CARNIVORE_FEEDER.get(), 1, new String[]{"IFI", "PCP", "IFI"}, Map.of(Character.valueOf('I'), Items.f_42416_, Character.valueOf('C'), Items.f_42009_, Character.valueOf('F'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), Character.valueOf('P'), Items.f_41869_), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_());
        this.shaped(out, RecipeCategory.MISC, (ItemLike)JSV1Blocks.AQUATIC_FEEDER.get(), 1, new String[]{"IDI", "FCF", "PDP"}, Map.of(Character.valueOf('I'), Items.f_42416_, Character.valueOf('C'), Items.f_42009_, Character.valueOf('F'), JSV1Blocks.FACILITY_CONCRETE.BLOCK.get(), Character.valueOf('P'), Items.f_41869_, Character.valueOf('D'), Items.f_151035_), (ItemLike)((Block)JSV1Blocks.FACILITY_CONCRETE.BLOCK.get()).m_5456_());
        List<StoneRegistries> v2Stones = List.of(JSV2Blocks.SHALE, JSV2Blocks.POLISHED_SHALE, JSV2Blocks.MOSSY_POLISHED_SHALE, JSV2Blocks.SHALE_BRICKS, JSV2Blocks.MOSSY_SHALE_BRICKS, JSV2Blocks.INTRICATE_SHALE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_SHALE_BRICKS, JSV2Blocks.RHYOLITE, JSV2Blocks.POLISHED_RHYOLITE, JSV2Blocks.MOSSY_POLISHED_RHYOLITE, JSV2Blocks.RHYOLITE_BRICKS, JSV2Blocks.MOSSY_RHYOLITE_BRICKS, JSV2Blocks.INTRICATE_RHYOLITE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_RHYOLITE_BRICKS);
        v2Stones.forEach(s -> this.completeStoneGroup(out, (StoneRegistries)s));
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.SHALE_BRICKS.BLOCK.get(), 8, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.SHALE.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.SHALE.BLOCK.get()).m_5456_());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.INTRICATE_SHALE_BRICKS.BLOCK.get(), 10, new String[]{"CCC", "CCC", "CCC"}, Map.of(Character.valueOf('C'), JSV2Blocks.SHALE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.SHALE_BRICKS.BLOCK.get()).m_5456_());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.POLISHED_SHALE.BLOCK.get(), 4, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.SHALE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.SHALE_BRICKS.BLOCK.get()).m_5456_());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get(), 8, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.RHYOLITE.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.RHYOLITE.BLOCK.get()).m_5456_());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.INTRICATE_RHYOLITE_BRICKS.BLOCK.get(), 10, new String[]{"CCC", "CCC", "CCC"}, Map.of(Character.valueOf('C'), JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()).m_5456_());
        this.shaped(out, RecipeCategory.DECORATIONS, (ItemLike)JSV2Blocks.POLISHED_RHYOLITE.BLOCK.get(), 4, new String[]{"CC", "CC"}, Map.of(Character.valueOf('C'), JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()), (ItemLike)((Block)JSV2Blocks.RHYOLITE_BRICKS.BLOCK.get()).m_5456_());
        this.mossySwap(out, JSV2Blocks.INTRICATE_SHALE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_SHALE_BRICKS);
        this.mossySwap(out, JSV2Blocks.SHALE_BRICKS, JSV2Blocks.MOSSY_SHALE_BRICKS);
        this.mossySwap(out, JSV2Blocks.POLISHED_SHALE, JSV2Blocks.MOSSY_POLISHED_SHALE);
        this.mossySwap(out, JSV2Blocks.INTRICATE_RHYOLITE_BRICKS, JSV2Blocks.MOSSY_INTRICATE_RHYOLITE_BRICKS);
        this.mossySwap(out, JSV2Blocks.RHYOLITE_BRICKS, JSV2Blocks.MOSSY_RHYOLITE_BRICKS);
        this.mossySwap(out, JSV2Blocks.POLISHED_RHYOLITE, JSV2Blocks.MOSSY_POLISHED_RHYOLITE);
    }

    private void buildAnimalRecipes(@NotNull Consumer<FinishedRecipe> out) {
        this.addCooking(out, ((Item)JSV1Items.SQUID.get()).m_7968_(), ((Item)JSV1Items.SQUID_COOKED.get()).m_7968_(), 600);
        for (JSAnimal<?> a : JSAnimals.getAnimals()) {
            JSItemProperties props = a.getAnimalAttributes().getItemProperties();
            if (!props.isHasDrops() || !props.isHasMeat()) continue;
            this.addCooking(out, ((Item)a.getItems().getRawMeat().get()).m_7968_(), ((Item)a.getItems().getCookedMeat().get()).m_7968_(), 600);
        }
    }

    private void addCooking(Consumer<FinishedRecipe> out, ItemStack in, ItemStack cooked, int time) {
        this.cooking(out, SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cooked.m_41720_(), (float)0.5f, (int)(time / 2)), in, cooked, "_smelt");
        this.cooking(out, SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cooked.m_41720_(), (float)0.5f, (int)(time / 2 - time / 2 / 5)), in, cooked, "_smoke");
        this.cooking(out, SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{in}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)cooked.m_41720_(), (float)0.5f, (int)time), in, cooked, "_campfire");
    }

    private void cooking(Consumer<FinishedRecipe> out, SimpleCookingRecipeBuilder b, ItemStack in, ItemStack cooked, String suffix) {
        b.m_126132_(JSCraftingProvider.m_176602_((ItemLike)in.m_41720_()), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)in.m_41720_())).m_126132_(JSCraftingProvider.m_176602_((ItemLike)cooked.m_41720_()), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)cooked.m_41720_())).m_176500_(out, String.valueOf(RecipeBuilder.m_176493_((ItemLike)cooked.m_41720_())) + suffix);
    }

    private void shaped(Consumer<FinishedRecipe> out, RecipeCategory cat, Supplier<? extends ItemLike> result, int count, String[] pattern, Map<Character, Object> keys, ItemLike unlock) {
        this.shaped(out, cat, (ItemLike)result.get(), count, pattern, keys, unlock);
    }

    private void shaped(Consumer<FinishedRecipe> out, RecipeCategory cat, ItemLike result, int count, String[] pattern, Map<Character, Object> keys, ItemLike unlock) {
        ShapedRecipeBuilder b = ShapedRecipeBuilder.m_246608_((RecipeCategory)cat, (ItemLike)result, (int)count);
        for (String line : pattern) {
            b.m_126130_(line);
        }
        keys.forEach((ch, obj) -> {
            if (obj instanceof ItemLike) {
                ItemLike il = (ItemLike)obj;
                b.m_126127_(ch, il);
            } else if (obj instanceof Block) {
                Block bl = (Block)obj;
                b.m_126127_(ch, (ItemLike)bl);
            } else if (obj instanceof TagKey) {
                TagKey tag = (TagKey)obj;
                b.m_206416_(ch, tag);
            } else {
                throw new IllegalArgumentException("Unsupported key type: " + String.valueOf(obj));
            }
        });
        b.m_126132_(JSCraftingProvider.m_176602_((ItemLike)unlock), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)unlock)).m_176498_(out);
    }

    private void shapeless(Consumer<FinishedRecipe> out, RecipeCategory cat, ItemLike result, int count, List<?> inputs, ItemLike unlock) {
        ShapelessRecipeBuilder b = ShapelessRecipeBuilder.m_246517_((RecipeCategory)cat, (ItemLike)result, (int)count);
        for (Object in : inputs) {
            if (in instanceof ItemLike) {
                ItemLike il = (ItemLike)in;
                b.m_126209_(il);
                continue;
            }
            if (in instanceof Ingredient) {
                Ingredient ing = (Ingredient)in;
                b.m_126184_(ing);
                continue;
            }
            if (in instanceof TagKey) {
                TagKey tag = (TagKey)in;
                b.m_126184_(Ingredient.m_204132_((TagKey)tag));
                continue;
            }
            throw new IllegalArgumentException("Unsupported shapeless input: " + String.valueOf(in));
        }
        b.m_126132_(JSCraftingProvider.m_176602_((ItemLike)unlock), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)unlock)).m_176498_(out);
    }

    private void shapelessCounts(Consumer<FinishedRecipe> out, RecipeCategory cat, ItemLike result, int count, Map<ItemLike, Integer> withCounts, ItemLike unlock) {
        this.shapelessCounts(out, cat, result, count, withCounts, unlock, List.of());
    }

    private void shapelessCounts(Consumer<FinishedRecipe> out, RecipeCategory cat, ItemLike result, int count, Map<ItemLike, Integer> withCounts, ItemLike unlock, List<Ingredient> extraIngredients) {
        ShapelessRecipeBuilder b = ShapelessRecipeBuilder.m_246517_((RecipeCategory)cat, (ItemLike)result, (int)count);
        withCounts.forEach((il, c) -> b.m_126211_(il, c.intValue()));
        extraIngredients.forEach(arg_0 -> ((ShapelessRecipeBuilder)b).m_126184_(arg_0));
        b.m_126132_(JSCraftingProvider.m_176602_((ItemLike)unlock), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)unlock)).m_176498_(out);
    }

    private void colorGroup(@NotNull Consumer<FinishedRecipe> out, ColoredRegistries color, Block base) {
        Map<Supplier, Item> map = Map.ofEntries(Map.entry(color.BLACK, Items.f_42498_), Map.entry(color.BLUE, Items.f_42494_), Map.entry(color.BROWN, Items.f_42495_), Map.entry(color.CYAN, Items.f_42492_), Map.entry(color.GREEN, Items.f_42496_), Map.entry(color.GREY, Items.f_42490_), Map.entry(color.LIGHTBLUE, Items.f_42538_), Map.entry(color.LIGHTGREY, Items.f_42491_), Map.entry(color.LIME, Items.f_42540_), Map.entry(color.MAGENTA, Items.f_42537_), Map.entry(color.ORANGE, Items.f_42536_), Map.entry(color.PINK, Items.f_42489_), Map.entry(color.PURPLE, Items.f_42493_), Map.entry(color.RED, Items.f_42497_), Map.entry(color.WHITE, Items.f_42535_), Map.entry(color.YELLOW, Items.f_42539_));
        map.forEach((supplier, dye) -> this.colorBlock(out, (Block)supplier.get(), base, (Item)dye));
    }

    private void colorBlock(@NotNull Consumer<FinishedRecipe> out, Block colored, Block base, Item dye) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)colored, (int)1).m_126211_((ItemLike)base, 1).m_126211_((ItemLike)dye, 1).m_126132_(JSCraftingProvider.m_176602_((ItemLike)base), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)base)).m_176500_(out, String.valueOf(RecipeBuilder.m_176493_((ItemLike)colored)) + "_colored");
    }

    private void stairSlabColoredGroup(@NotNull Consumer<FinishedRecipe> out, ColoredRegistries stairs, ColoredRegistries slabs, ColoredRegistries bases) {
        List.of((Block)stairs.BLACK.get(), (Block)stairs.BLUE.get(), (Block)stairs.BROWN.get(), (Block)stairs.CYAN.get(), (Block)stairs.GREEN.get(), (Block)stairs.GREY.get(), (Block)stairs.LIGHTBLUE.get(), (Block)stairs.LIGHTGREY.get(), (Block)stairs.LIME.get(), (Block)stairs.MAGENTA.get(), (Block)stairs.ORANGE.get(), (Block)stairs.PINK.get(), (Block)stairs.PURPLE.get(), (Block)stairs.RED.get(), (Block)stairs.WHITE.get(), (Block)stairs.YELLOW.get()).forEach(block -> {});
        this.stairSlabColored(out, (Block)stairs.BLACK.get(), (Block)slabs.BLACK.get(), (Block)bases.BLACK.get());
        this.stairSlabColored(out, (Block)stairs.BLUE.get(), (Block)slabs.BLUE.get(), (Block)bases.BLUE.get());
        this.stairSlabColored(out, (Block)stairs.BROWN.get(), (Block)slabs.BROWN.get(), (Block)bases.BROWN.get());
        this.stairSlabColored(out, (Block)stairs.CYAN.get(), (Block)slabs.CYAN.get(), (Block)bases.CYAN.get());
        this.stairSlabColored(out, (Block)stairs.GREEN.get(), (Block)slabs.GREEN.get(), (Block)bases.GREEN.get());
        this.stairSlabColored(out, (Block)stairs.GREY.get(), (Block)slabs.GREY.get(), (Block)bases.GREY.get());
        this.stairSlabColored(out, (Block)stairs.LIGHTBLUE.get(), (Block)slabs.LIGHTBLUE.get(), (Block)bases.LIGHTBLUE.get());
        this.stairSlabColored(out, (Block)stairs.LIGHTGREY.get(), (Block)slabs.LIGHTGREY.get(), (Block)bases.LIGHTGREY.get());
        this.stairSlabColored(out, (Block)stairs.LIME.get(), (Block)slabs.LIME.get(), (Block)bases.LIME.get());
        this.stairSlabColored(out, (Block)stairs.MAGENTA.get(), (Block)slabs.MAGENTA.get(), (Block)bases.MAGENTA.get());
        this.stairSlabColored(out, (Block)stairs.ORANGE.get(), (Block)slabs.ORANGE.get(), (Block)bases.ORANGE.get());
        this.stairSlabColored(out, (Block)stairs.PINK.get(), (Block)slabs.PINK.get(), (Block)bases.PINK.get());
        this.stairSlabColored(out, (Block)stairs.PURPLE.get(), (Block)slabs.PURPLE.get(), (Block)bases.PURPLE.get());
        this.stairSlabColored(out, (Block)stairs.RED.get(), (Block)slabs.RED.get(), (Block)bases.RED.get());
        this.stairSlabColored(out, (Block)stairs.WHITE.get(), (Block)slabs.WHITE.get(), (Block)bases.WHITE.get());
        this.stairSlabColored(out, (Block)stairs.YELLOW.get(), (Block)slabs.YELLOW.get(), (Block)bases.YELLOW.get());
    }

    private void stairSlabColored(@NotNull Consumer<FinishedRecipe> out, Block stair, Block slab, Block base) {
        JSCraftingProvider.m_176710_((ItemLike)stair, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)base), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)base)).m_176500_(out, String.valueOf(RecipeBuilder.m_176493_((ItemLike)stair)) + "stair");
        JSCraftingProvider.m_246658_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base);
    }

    private void stoneFamily(@NotNull Consumer<FinishedRecipe> out, StoneRegistries family) {
        this.stairSlabWallStonecutter(out, (Block)family.STAIRS.get(), (Block)family.WALL.get(), (Block)family.SLAB.get(), (Block)family.BLOCK.get());
    }

    private void basicFamily(@NotNull Consumer<FinishedRecipe> out, BasicBlockSetRegistries family) {
        this.stairSlabWallStonecutter(out, (Block)family.STAIRS.get(), (Block)family.WALL.get(), (Block)family.SLAB.get(), (Block)family.BLOCK.get());
    }

    private void mossify(@NotNull Consumer<FinishedRecipe> out, StoneRegistries base, StoneRegistries mossy) {
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)mossy.BLOCK.get(), 8, Map.of(((Block)base.BLOCK.get()).m_5456_(), 8), (ItemLike)((Block)base.BLOCK.get()).m_5456_(), List.of(Ingredient.m_204132_(JSItemTags.MOSS)));
        this.stoneFamily(out, mossy);
    }

    private void mossifyBasic(@NotNull Consumer<FinishedRecipe> out, BasicBlockSetRegistries base, BasicBlockSetRegistries mossy) {
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)mossy.BLOCK.get(), 8, Map.of(((Block)base.BLOCK.get()).m_5456_(), 8), (ItemLike)((Block)base.BLOCK.get()).m_5456_(), List.of(Ingredient.m_204132_(JSItemTags.MOSS)));
        this.basicFamily(out, mossy);
    }

    private void mossySwap(@NotNull Consumer<FinishedRecipe> out, StoneRegistries base, StoneRegistries mossy) {
        this.shapelessCounts(out, RecipeCategory.DECORATIONS, (ItemLike)mossy.BLOCK.get(), 8, Map.of(((Block)base.BLOCK.get()).m_5456_(), 8), (ItemLike)((Block)base.BLOCK.get()).m_5456_(), List.of(Ingredient.m_204132_(JSItemTags.MOSS)));
    }

    private void completeStoneGroup(@NotNull Consumer<FinishedRecipe> out, StoneRegistries s) {
        JSCraftingProvider.m_176690_(out, (ItemLike)((ItemLike)s.getPRESSURE_PLATE().get()), (ItemLike)((ItemLike)s.getBLOCK().get()));
        JSCraftingProvider.m_176658_((ItemLike)((ItemLike)s.BUTTON.get()), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)s.BLOCK.get()})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)((ItemLike)s.BLOCK.get())), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)((ItemLike)s.BLOCK.get()))).m_176498_(out);
        this.stairSlabWallStonecutter(out, (Block)s.STAIRS.get(), (Block)s.WALL.get(), (Block)s.SLAB.get(), (Block)s.BLOCK.get());
    }

    private void stairSlabWallStonecutter(@NotNull Consumer<FinishedRecipe> out, Block stair, Block wall, Block slab, Block base) {
        JSCraftingProvider.m_176710_((ItemLike)stair, (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base})).m_126132_(JSCraftingProvider.m_176602_((ItemLike)base), (CriterionTriggerInstance)JSCraftingProvider.m_125977_((ItemLike)base)).m_176500_(out, String.valueOf(RecipeBuilder.m_176493_((ItemLike)stair)) + "stair");
        JSCraftingProvider.m_246382_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)base);
        JSCraftingProvider.m_246658_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base);
        JSCraftingProvider.m_247600_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stair, (ItemLike)base);
        JSCraftingProvider.m_247600_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wall, (ItemLike)base);
        JSCraftingProvider.m_247298_(out, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (ItemLike)base, (int)2);
    }
}

