/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.neo.server.world;

import java.util.ArrayList;
import jp.jurassicsaga.server.v1.world.feature.JSV1PlacedFeatures;
import jp.jurassicsaga.server.v2.world.feature.JSV2PlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import travelers.world.NeoTravelersBiomeModificator;

public class JSBiomeModifiers {
    public static final ResourceKey<BiomeModifier> OVERWORLD_ORES = JSBiomeModifiers.registerOre("overworld_ores");
    public static final ResourceKey<BiomeModifier> SHALE = JSBiomeModifiers.registerOre("shale");
    public static final ResourceKey<BiomeModifier> RHYOLITE = JSBiomeModifiers.registerOre("rhyolite");
    public static final ResourceKey<BiomeModifier> HELICONIA = JSBiomeModifiers.registerOre("heliconia");
    public static final ResourceKey<BiomeModifier> ROYAL_FERN = JSBiomeModifiers.registerOre("royal_fern");
    public static final ResourceKey<BiomeModifier> WEST_INDIAN_LILAC = JSBiomeModifiers.registerOre("west_indian_lilac");
    public static final ResourceKey<BiomeModifier> SWISS_CHEESE_PLANT = JSBiomeModifiers.registerOre("swiss_cheese_plant");

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        HolderGetter features = context.m_255420_(Registries.f_256988_);
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        ArrayList ores = new ArrayList();
        JSV1PlacedFeatures.ERA_KEYS.forEach((era, resourceKeyResourceKeyPair) -> {
            if (era.isHasMarineOre()) {
                ores.add(features.m_255043_((ResourceKey)resourceKeyResourceKeyPair.getSecond()));
            }
            if (era.isHasFossilOre()) {
                ores.add(features.m_255043_((ResourceKey)resourceKeyResourceKeyPair.getFirst()));
            }
        });
        context.m_255272_(OVERWORLD_ORES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_215817_), (HolderSet)HolderSet.m_205800_(ores), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(WEST_INDIAN_LILAC, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186754_), biomes.m_255043_(Biomes.f_186765_)}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{features.m_255043_(JSV1PlacedFeatures.WEST_INDIAN_LILAC)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(SWISS_CHEESE_PLANT, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_186769_)}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{features.m_255043_(JSV1PlacedFeatures.SWISS_CHEESE_PLANT)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(HELICONIA, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48222_), biomes.m_255043_(Biomes.f_48197_)}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{features.m_255043_(JSV1PlacedFeatures.HELICONIA)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ROYAL_FERN, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(Tags.Biomes.IS_SWAMP), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{features.m_255043_(JSV1PlacedFeatures.ROYAL_FERN)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(SHALE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{features.m_255043_(JSV2PlacedFeatures.SHALE)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(RHYOLITE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{features.m_255043_(JSV2PlacedFeatures.RHYOLITE)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        NeoTravelersBiomeModificator.bootstrap((String)"jurassicsaga", context);
    }

    public static ResourceKey<BiomeModifier> registerOre(String name) {
        return JSBiomeModifiers.registerKey("ore/" + name);
    }

    public static ResourceKey<BiomeModifier> registerVegetation(String name) {
        return JSBiomeModifiers.registerKey("vegetation/" + name);
    }

    public static ResourceKey<BiomeModifier> registerEntity(String name) {
        return JSBiomeModifiers.registerKey("entity/" + name);
    }

    public static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("jurassicsaga", name));
    }
}

