/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.util.function.BiConsumer;
import jp.jurassicsaga.JSConstants;
import jp.jurassicsaga.mixin.GameRulesIntAccessor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class JSBoundedIntRule
extends GameRules.IntegerValue {
    private static final Logger LOGGER = JSConstants.LOG;
    private final int minimumValue;
    private final int maximumValue;

    public JSBoundedIntRule(GameRules.Type<GameRules.IntegerValue> type, int initialValue, int minimumValue, int maximumValue) {
        super(type, initialValue);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    protected void m_7377_(@NotNull String value) {
        int i = JSBoundedIntRule.m_46317_(value);
        if (this.minimumValue > i || this.maximumValue < i) {
            LOGGER.warn("Failed to parse integer {}. Was out of bounds {} - {}", new Object[]{value, this.minimumValue, this.maximumValue});
            return;
        }
        ((GameRulesIntAccessor)((Object)this)).setValue(i);
    }

    public static GameRules.Type<GameRules.IntegerValue> create(int defaultValue, int minimumValue, int maximumValue, @Nullable BiConsumer<MinecraftServer, GameRules.IntegerValue> changedCallback) {
        return new GameRules.Type(() -> IntegerArgumentType.integer((int)minimumValue, (int)maximumValue), type -> new JSBoundedIntRule((GameRules.Type<GameRules.IntegerValue>)type, defaultValue, minimumValue, maximumValue), changedCallback, GameRules.GameRuleTypeVisitor::m_6894_);
    }

    public boolean m_46314_(@NotNull String input) {
        try {
            int value = Integer.parseInt(input);
            if (this.minimumValue > value || this.maximumValue < value) {
                return false;
            }
            ((GameRulesIntAccessor)((Object)this)).setValue(value);
            return true;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GameRules.IntegerValue m_5590_() {
        return new JSBoundedIntRule((GameRules.Type<GameRules.IntegerValue>)this.f_46360_, ((GameRulesIntAccessor)((Object)this)).getValue(), this.minimumValue, this.maximumValue);
    }

    private static int m_46317_(String input) {
        if (!input.isEmpty()) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException var2) {
                LOGGER.warn("Failed to parse integer {}", (Object)input);
            }
        }
        return 0;
    }
}

