/*
 * Decompiled with CFR 0.152.
 */
package jp.jurassicsaga.server.base.animal.entity.obj.bases;

import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAnimalBase;
import jp.jurassicsaga.server.base.animal.entity.obj.bases.JSAquaticBase;
import jp.jurassicsaga.server.base.animal.entity.obj.nav.JSAmphibiousNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.control.TravelersSmoothSwimMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class JSAmphibiousBase
extends JSAnimalBase {
    public JSAmphibiousBase(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.setPathfindingMalus(TravelersPathType.WATER_BORDER, 0.0f);
        this.setPathfindingMalus(TravelersPathType.TRAPDOOR, -1.0f);
        this.moveController = new TravelersSmoothSwimMoveControl((SmartAnimalBase)this, this.getAnimal().getAnimalAttributes().getMiscProperties().getMaxHeadXRot(), this.getAnimal().getAnimalAttributes().getMiscProperties().getMaxHeadYRot(), 0.01f, 0.1f, true);
    }

    public boolean isAmphibian() {
        return true;
    }

    @Override
    public boolean shouldSleep() {
        return !this.m_20069_() && super.shouldSleep();
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<? extends JSAquaticBase> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public boolean canSwim() {
        return true;
    }

    @Override
    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (!this.m_9236_().f_46443_ && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.6));
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (this.usesAir()) {
            this.handleAirSupply(i);
        }
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && this.invertAir() != this.m_20072_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public int m_20146_() {
        return this.usesAir() ? super.m_20146_() : this.m_6062_();
    }

    protected float m_6108_() {
        return 0.1f;
    }

    public double m_20204_() {
        return this.m_274421_();
    }

    @Override
    protected TravelersPathNavigation createNavigationController(Level level) {
        return new JSAmphibiousNavigation(this, level, this.shallowSwimming());
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_20069_()) {
            if (this.sinkToBottom() || this.isDead() || !this.isStalking() && !this.m_204029_(FluidTags.f_13131_)) {
                if (!this.m_20096_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -this.getSinkRate(), 0.0));
                }
            } else if (!this.m_9236_().f_46443_) {
                TravelersPathNavigation navigator = this.getNavigationController();
                TravelersPath path = navigator.getPath();
                if (!this.m_20096_() && (this.m_20069_() || this.f_19800_) && path != null && !path.isDone()) {
                    double y;
                    double difference;
                    Vec3 pathPos = path.getNextEntityPos((Entity)this);
                    if (navigator.isStuck()) {
                        navigator.stop();
                    }
                    if (Math.abs(difference = pathPos.f_82480_ - (y = this.m_20182_().f_82480_)) > 0.1) {
                        if (difference > 0.0) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, difference > 2.0 ? this.getSinkRate() * 2.0 : this.getSinkRate(), 0.0));
                        } else {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, difference < -2.0 ? -this.getSinkRate() * 2.0 : -this.getSinkRate(), 0.0));
                        }
                    }
                }
            }
        }
    }

    protected double getSinkRate() {
        return 0.05f;
    }

    protected boolean sinkToBottom() {
        return true;
    }

    protected boolean usesAir() {
        return true;
    }

    protected boolean invertAir() {
        return false;
    }

    public boolean shallowSwimming() {
        return false;
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }
}

